/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionProducerCreditsMessage
extends PacketImpl {
    private int credits;
    private SimpleString address;

    public SessionProducerCreditsMessage(int credits, SimpleString address) {
        super((byte)80);
        this.credits = credits;
        this.address = address;
    }

    public SessionProducerCreditsMessage() {
        super((byte)80);
    }

    public int getCredits() {
        return this.credits;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeInt(this.credits);
        buffer.writeSimpleString(this.address);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.credits = buffer.readInt();
        this.address = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + this.credits;
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", address=" + String.valueOf(this.address));
        sb.append(", credits=" + this.credits);
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionProducerCreditsMessage)) {
            return false;
        }
        SessionProducerCreditsMessage other = (SessionProducerCreditsMessage)obj;
        if (this.address == null ? other.address != null : !this.address.equals((Object)other.address)) {
            return false;
        }
        return this.credits == other.credits;
    }
}

