/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.postgres;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.domainlist.postgres.PostgresDomainDataDefinition;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.exception.DataAccessException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PostgresDomainList
extends AbstractDomainList {
    private final PostgresExecutor postgresExecutor;

    @Inject
    public PostgresDomainList(DNSService dnsService, @Named(value="default") PostgresExecutor postgresExecutor) {
        super(dnsService);
        this.postgresExecutor = postgresExecutor;
    }

    public void addDomain(Domain domain) throws DomainListException {
        try {
            this.postgresExecutor.executeVoid(dslContext -> Mono.from((Publisher)dslContext.insertInto(PostgresDomainDataDefinition.PostgresDomainTable.TABLE_NAME, PostgresDomainDataDefinition.PostgresDomainTable.DOMAIN).values((Object)domain.asString()))).block();
        }
        catch (DataAccessException exception) {
            throw new DomainListException(domain.name() + " already exists.");
        }
    }

    protected List<Domain> getDomainListInternal() {
        return (List)this.postgresExecutor.executeRows(dsl -> Flux.from((Publisher)dsl.selectFrom(PostgresDomainDataDefinition.PostgresDomainTable.TABLE_NAME))).map(record -> Domain.of((String)((String)record.get(PostgresDomainDataDefinition.PostgresDomainTable.DOMAIN)))).collectList().block();
    }

    protected boolean containsDomainInternal(Domain domain) {
        return this.postgresExecutor.executeRow(dsl -> Mono.from((Publisher)dsl.selectFrom(PostgresDomainDataDefinition.PostgresDomainTable.TABLE_NAME).where(PostgresDomainDataDefinition.PostgresDomainTable.DOMAIN.eq((Object)domain.asString())))).blockOptional().isPresent();
    }

    protected void doRemoveDomain(Domain domain) throws DomainListException {
        boolean executed = this.postgresExecutor.executeRow(dslContext -> Mono.from((Publisher)dslContext.deleteFrom(PostgresDomainDataDefinition.PostgresDomainTable.TABLE_NAME).where(PostgresDomainDataDefinition.PostgresDomainTable.DOMAIN.eq((Object)domain.asString())).returning(new SelectFieldOrAsterisk[]{PostgresDomainDataDefinition.PostgresDomainTable.DOMAIN}))).blockOptional().isPresent();
        if (!executed) {
            throw new DomainListException(domain.name() + " was not found");
        }
    }
}

