/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.InstructionPtrStrategy;
import serp.bytecode.JumpInstruction;

public abstract class SwitchInstruction
extends JumpInstruction {
    private List _cases = new LinkedList();

    public SwitchInstruction(Code owner, int opcode) {
        super(owner, opcode);
    }

    public int[] getOffsets() {
        int bi = this.getByteIndex();
        int[] offsets = new int[this._cases.size()];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = ((InstructionPtrStrategy)this._cases.get(i)).getByteIndex() - bi;
        }
        return offsets;
    }

    public void setOffsets(int[] offsets) {
        int bi = this.getByteIndex();
        this._cases.clear();
        for (int i = 0; i < offsets.length; ++i) {
            InstructionPtrStrategy next = new InstructionPtrStrategy(this);
            next.setByteIndex(offsets[i] + bi);
            this._cases.add(next);
        }
    }

    public int countTargets() {
        return this._cases.size();
    }

    @Override
    int getLength() {
        int length = 1;
        int byteIndex = this.getByteIndex() + 1;
        while (byteIndex % 4 != 0) {
            ++byteIndex;
            ++length;
        }
        return length;
    }

    public Instruction getDefaultTarget() {
        return this.getTarget();
    }

    public int getDefaultOffset() {
        return this.getOffset();
    }

    public SwitchInstruction setDefaultOffset(int offset) {
        this.setOffset(offset);
        return this;
    }

    public SwitchInstruction setDefaultTarget(Instruction ins) {
        return (SwitchInstruction)this.setTarget(ins);
    }

    public Instruction[] getTargets() {
        Instruction[] result = new Instruction[this._cases.size()];
        for (int i = 0; i < this._cases.size(); ++i) {
            result[i] = ((InstructionPtrStrategy)this._cases.get(i)).getTargetInstruction();
        }
        return result;
    }

    public SwitchInstruction setTargets(Instruction[] targets) {
        this._cases.clear();
        if (targets != null) {
            for (int i = 0; i < targets.length; ++i) {
                this.addTarget(targets[i]);
            }
        }
        return this;
    }

    public SwitchInstruction addTarget(Instruction target) {
        this._cases.add(new InstructionPtrStrategy(this, target));
        return this;
    }

    @Override
    public int getStackChange() {
        return -1;
    }

    @Override
    public void updateTargets() {
        super.updateTargets();
        Iterator itr = this._cases.iterator();
        while (itr.hasNext()) {
            ((InstructionPtrStrategy)itr.next()).updateTargets();
        }
    }

    @Override
    public void replaceTarget(Instruction oldTarget, Instruction newTarget) {
        super.replaceTarget(oldTarget, newTarget);
        Iterator itr = this._cases.iterator();
        while (itr.hasNext()) {
            ((InstructionPtrStrategy)itr.next()).replaceTarget(oldTarget, newTarget);
        }
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        SwitchInstruction ins = (SwitchInstruction)orig;
        this._cases.clear();
        for (InstructionPtrStrategy incoming : ins._cases) {
            InstructionPtrStrategy next = new InstructionPtrStrategy(this);
            next.setByteIndex(incoming.getByteIndex());
            this._cases.add(next);
        }
    }

    void clearTargets() {
        this._cases.clear();
    }

    void readTarget(DataInput in) throws IOException {
        InstructionPtrStrategy next = new InstructionPtrStrategy(this);
        next.setByteIndex(this.getByteIndex() + in.readInt());
        this._cases.add(next);
    }

    public SwitchInstruction setCases(int[] matches, Instruction[] targets) {
        this.setMatches(matches);
        this.setTargets(targets);
        return this;
    }

    public SwitchInstruction setMatches(int[] matches) {
        this.clearMatches();
        for (int i = 0; i < matches.length; ++i) {
            this.addMatch(matches[i]);
        }
        return this;
    }

    public SwitchInstruction addCase(int match, Instruction target) {
        this.addMatch(match);
        this.addTarget(target);
        return this;
    }

    public abstract SwitchInstruction addMatch(int var1);

    public abstract int[] getMatches();

    abstract void clearMatches();

    void calculateOpcode() {
    }
}

