/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.quota;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.MaxQuotaManager;

public class InMemoryPerUserMaxQuotaManager
implements MaxQuotaManager {
    private Optional<QuotaCountLimit> maxMessage = Optional.empty();
    private Optional<QuotaSizeLimit> maxStorage = Optional.empty();
    private final Map<Domain, QuotaCountLimit> domainMaxMessage = new ConcurrentHashMap<Domain, QuotaCountLimit>();
    private final Map<Domain, QuotaSizeLimit> domainMaxStorage = new ConcurrentHashMap<Domain, QuotaSizeLimit>();
    private final Map<String, QuotaSizeLimit> userMaxStorage = new ConcurrentHashMap<String, QuotaSizeLimit>();
    private final Map<String, QuotaCountLimit> userMaxMessage = new ConcurrentHashMap<String, QuotaCountLimit>();

    public void setGlobalMaxStorage(QuotaSizeLimit maxStorage) {
        this.maxStorage = Optional.of(maxStorage);
    }

    public void setDomainMaxMessage(Domain domain, QuotaCountLimit count) {
        this.domainMaxMessage.put(domain, count);
    }

    public void setDomainMaxStorage(Domain domain, QuotaSizeLimit size) {
        this.domainMaxStorage.put(domain, size);
    }

    public void removeDomainMaxMessage(Domain domain) {
        this.domainMaxMessage.remove(domain);
    }

    public void removeDomainMaxStorage(Domain domain) {
        this.domainMaxStorage.remove(domain);
    }

    public Map<Quota.Scope, QuotaCountLimit> listMaxMessagesDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxMessage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, Optional.ofNullable(this.userMaxMessage.get(quotaRoot.getValue()))), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.maxMessage)).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Pair::getKey, value -> (QuotaCountLimit)((Optional)value.getValue()).get()));
    }

    public Map<Quota.Scope, QuotaSizeLimit> listMaxStorageDetails(QuotaRoot quotaRoot) {
        Function domainQuotaFunction = Throwing.function(this::getDomainMaxStorage).sneakyThrow();
        return (Map)Stream.of(Pair.of((Object)Quota.Scope.User, Optional.ofNullable(this.userMaxStorage.get(quotaRoot.getValue()))), Pair.of((Object)Quota.Scope.Domain, quotaRoot.getDomain().flatMap(domainQuotaFunction)), Pair.of((Object)Quota.Scope.Global, this.maxStorage)).filter(pair -> ((Optional)pair.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Pair::getKey, value -> (QuotaSizeLimit)((Optional)value.getValue()).get()));
    }

    public void setGlobalMaxMessage(QuotaCountLimit maxMessage) {
        this.maxMessage = Optional.of(maxMessage);
    }

    public Optional<QuotaCountLimit> getDomainMaxMessage(Domain domain) {
        return Optional.ofNullable(this.domainMaxMessage.get(domain));
    }

    public Optional<QuotaSizeLimit> getDomainMaxStorage(Domain domain) {
        return Optional.ofNullable(this.domainMaxStorage.get(domain));
    }

    public void setMaxStorage(QuotaRoot user, QuotaSizeLimit maxStorageQuota) {
        this.userMaxStorage.put(user.getValue(), maxStorageQuota);
    }

    public void setMaxMessage(QuotaRoot quotaRoot, QuotaCountLimit maxMessageCount) {
        this.userMaxMessage.put(quotaRoot.getValue(), maxMessageCount);
    }

    public Optional<QuotaSizeLimit> getGlobalMaxStorage() {
        return this.maxStorage;
    }

    public Optional<QuotaCountLimit> getGlobalMaxMessage() {
        return this.maxMessage;
    }

    public void removeMaxMessage(QuotaRoot quotaRoot) {
        this.userMaxMessage.remove(quotaRoot.getValue());
    }

    public void removeMaxStorage(QuotaRoot quotaRoot) {
        this.userMaxStorage.remove(quotaRoot.getValue());
    }

    public void removeGlobalMaxStorage() {
        this.maxStorage = Optional.empty();
    }

    public void removeGlobalMaxMessage() {
        this.maxMessage = Optional.empty();
    }
}

