/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.mail.Flags;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.inmemory.mail.InMemoryMessageMapper;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.MailboxReactorUtils;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.MessageIdMapper;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class InMemoryMessageIdMapper
implements MessageIdMapper {
    private final MailboxMapper mailboxMapper;
    private final InMemoryMessageMapper messageMapper;

    public InMemoryMessageIdMapper(MailboxMapper mailboxMapper, InMemoryMessageMapper messageMapper) {
        this.mailboxMapper = mailboxMapper;
        this.messageMapper = messageMapper;
    }

    public List<MailboxMessage> find(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return (List)this.findReactive(messageIds, fetchType).collect(ImmutableList.toImmutableList()).block();
    }

    public Publisher<ComposedMessageIdWithMetaData> findMetadata(MessageId messageId) {
        return this.mailboxMapper.list().flatMap(mailbox -> this.messageMapper.findInMailboxReactive((Mailbox)mailbox, MessageRange.all(), MessageMapper.FetchType.FULL, -1), 16).map(message -> new ComposedMessageIdWithMetaData(new ComposedMessageId(message.getMailboxId(), message.getMessageId(), message.getUid()), message.createFlags(), message.getModSeq(), message.getThreadId()));
    }

    public Flux<MailboxMessage> findReactive(Collection<MessageId> messageIds, MessageMapper.FetchType fetchType) {
        return this.mailboxMapper.list().flatMap(mailbox -> this.messageMapper.findInMailboxReactive((Mailbox)mailbox, MessageRange.all(), fetchType, -1), 16).filter(message -> messageIds.contains(message.getMessageId()));
    }

    public List<MailboxId> findMailboxes(MessageId messageId) {
        return (List)this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA).stream().map(MailboxMessage::getMailboxId).collect(ImmutableList.toImmutableList());
    }

    public void save(MailboxMessage mailboxMessage) throws MailboxException {
        Mailbox mailbox = (Mailbox)MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById(mailboxMessage.getMailboxId()));
        this.messageMapper.save(mailbox, mailboxMessage);
    }

    public void copyInMailbox(MailboxMessage mailboxMessage, Mailbox mailbox) throws MailboxException {
        boolean isAlreadyInMailbox = this.findMailboxes(mailboxMessage.getMessageId()).contains(mailbox.getMailboxId());
        if (!isAlreadyInMailbox) {
            this.save(mailboxMessage);
        }
    }

    public void delete(MessageId messageId) {
        this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA).forEach(Throwing.consumer(message -> this.messageMapper.delete((Mailbox)MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById(message.getMailboxId())), (MailboxMessage)message)));
    }

    public void delete(MessageId messageId, Collection<MailboxId> mailboxIds) {
        this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA).stream().filter(message -> mailboxIds.contains(message.getMailboxId())).forEach((Consumer<MailboxMessage>)Throwing.consumer(message -> this.messageMapper.delete((Mailbox)MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById(message.getMailboxId())), (MailboxMessage)message)));
    }

    public Mono<Multimap<MailboxId, UpdatedFlags>> setFlags(MessageId messageId, List<MailboxId> mailboxIds, Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        return Mono.fromCallable(() -> (Multimap)this.find((Collection<MessageId>)ImmutableList.of((Object)messageId), MessageMapper.FetchType.METADATA).stream().filter(message -> mailboxIds.contains(message.getMailboxId())).map(this.updateMessage(newState, updateMode)).distinct().collect(ImmutableListMultimap.toImmutableListMultimap(Pair::getKey, Pair::getValue))).subscribeOn(Schedulers.elastic());
    }

    private Function<MailboxMessage, Pair<MailboxId, UpdatedFlags>> updateMessage(Flags newState, MessageManager.FlagsUpdateMode updateMode) {
        return Throwing.function(message -> {
            FlagsUpdateCalculator flagsUpdateCalculator = new FlagsUpdateCalculator(newState, updateMode);
            if (flagsUpdateCalculator.buildNewFlags(message.createFlags()).equals((Object)message.createFlags())) {
                UpdatedFlags updatedFlags = UpdatedFlags.builder().modSeq(message.getModSeq()).uid(message.getUid()).messageId(message.getMessageId()).oldFlags(message.createFlags()).newFlags(newState).build();
                return Pair.of((Object)message.getMailboxId(), (Object)updatedFlags);
            }
            return Pair.of((Object)message.getMailboxId(), (Object)((UpdatedFlags)this.messageMapper.updateFlags((Mailbox)MailboxReactorUtils.block((Mono)this.mailboxMapper.findMailboxById(message.getMailboxId())), flagsUpdateCalculator, message.getUid().toRange()).next()));
        });
    }
}

