/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.repository.file;

import java.io.File;
import java.io.FilenameFilter;

public class NumberedRepositoryFileFilter
implements FilenameFilter {
    private final String postfix;
    private final String prefix;

    public NumberedRepositoryFileFilter(String extension) {
        this.postfix = extension;
        this.prefix = ".Repository";
    }

    @Override
    public boolean accept(File file, String name) {
        if (!name.endsWith(this.postfix)) {
            return false;
        }
        int pos = name.length() - this.postfix.length();
        if (!Character.isDigit(name.charAt(pos - 1))) {
            return false;
        }
        --pos;
        while (pos >= 1 && Character.isDigit(name.charAt(pos - 1))) {
            --pos;
        }
        return name.substring(0, pos).endsWith(this.prefix);
    }
}

