/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.client.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.eventstream.HeaderValue;
import software.amazon.eventstream.Message;

@SdkProtectedApi
public final class AwsClientHandlerUtils {
    private AwsClientHandlerUtils() {
    }

    public static ByteBuffer encodeEventStreamRequestToByteBuffer(SdkHttpFullRequest request) {
        Map<String, HeaderValue> headers = request.headers().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> HeaderValue.fromString((String)((String)CollectionUtils.firstIfPresent((List)((List)e.getValue()))))));
        byte[] payload = null;
        if (request.contentStreamProvider().isPresent()) {
            try {
                payload = IoUtils.toByteArray((InputStream)((ContentStreamProvider)request.contentStreamProvider().get()).newStream());
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
        return new Message(headers, payload).toByteBuffer();
    }
}

