/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model;

import org.apache.james.jmap.api.access.AccessToken;

public class AccessTokenResponse {
    private final AccessToken accessToken;
    private final String api;
    private final String eventSource;
    private final String upload;
    private final String download;

    public static Builder builder() {
        return new Builder();
    }

    private AccessTokenResponse(AccessToken accessToken, String api, String eventSource, String upload, String download) {
        this.accessToken = accessToken;
        this.api = api;
        this.eventSource = eventSource;
        this.upload = upload;
        this.download = download;
    }

    public String getAccessToken() {
        return this.accessToken.serialize();
    }

    public String getApi() {
        return this.api;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public String getUpload() {
        return this.upload;
    }

    public String getDownload() {
        return this.download;
    }

    public static class Builder {
        private AccessToken accessToken;
        private String api;
        private String eventSource;
        private String upload;
        private String download;

        private Builder() {
        }

        public Builder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder api(String api) {
            this.api = api;
            return this;
        }

        public Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public Builder upload(String upload) {
            this.upload = upload;
            return this;
        }

        public Builder download(String download) {
            this.download = download;
            return this;
        }

        public AccessTokenResponse build() {
            return new AccessTokenResponse(this.accessToken, this.api, this.eventSource, this.upload, this.download);
        }
    }
}

