/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    public final String name;
    private final ThreadFactory threadFactory;

    public static NamedThreadFactory withClassName(Class<?> clazz) {
        return new NamedThreadFactory(clazz.getName());
    }

    public static NamedThreadFactory withName(String name) {
        return new NamedThreadFactory(name);
    }

    private NamedThreadFactory(String name) {
        this.name = name;
        this.threadFactory = new ThreadFactoryBuilder().setNameFormat(name + "-%d").build();
    }

    @Override
    public Thread newThread(Runnable r) {
        return this.threadFactory.newThread(r);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NamedThreadFactory: " + this.getName();
    }
}

