/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.Date;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.queue.rabbitmq.MailQueueName;
import reactor.core.publisher.Mono;

public class ContentStartDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement selectOne;
    private final PreparedStatement insertOne;
    private final PreparedStatement updateOne;

    @Inject
    ContentStartDAO(Session session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.selectOne = this.prepareSelectOne(session);
        this.updateOne = this.prepareUpdate(session);
        this.insertOne = this.prepareInsertOne(session);
    }

    private PreparedStatement prepareSelectOne(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.select().from("contentStart").where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))));
    }

    private PreparedStatement prepareUpdate(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.update((String)"contentStart").with(QueryBuilder.set((String)"contentStart", (Object)QueryBuilder.bindMarker((String)"contentStart"))).where(QueryBuilder.eq((String)"queueName", (Object)QueryBuilder.bindMarker((String)"queueName"))));
    }

    private PreparedStatement prepareInsertOne(Session session) {
        return session.prepare((RegularStatement)QueryBuilder.insertInto((String)"contentStart").ifNotExists().value("contentStart", (Object)QueryBuilder.bindMarker((String)"contentStart")).value("queueName", (Object)QueryBuilder.bindMarker((String)"queueName")));
    }

    Mono<Instant> findContentStart(MailQueueName queueName) {
        return this.selectOne(queueName).map(this::getContentStart);
    }

    Mono<Void> updateContentStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)this.updateOne.bind().setTimestamp("contentStart", Date.from(sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    Mono<Void> insertInitialContentStart(MailQueueName mailQueueName, Instant sliceStart) {
        return this.executor.executeVoid((Statement)this.insertOne.bind().setTimestamp("contentStart", Date.from(sliceStart)).setString("queueName", mailQueueName.asString()));
    }

    @VisibleForTesting
    Mono<Row> selectOne(MailQueueName queueName) {
        return this.executor.executeSingleRow((Statement)this.selectOne.bind().setString("queueName", queueName.asString()));
    }

    private Instant getContentStart(Row row) {
        return row.getTimestamp("contentStart").toInstant();
    }
}

