/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2FrameCodec;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Schedulers;
import reactor.netty.Connection;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.internal.shaded.reactor.pool.InstrumentedPool;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquirePendingLimitException;
import reactor.netty.internal.shaded.reactor.pool.PoolAcquireTimeoutException;
import reactor.netty.internal.shaded.reactor.pool.PoolConfig;
import reactor.netty.internal.shaded.reactor.pool.PoolShutdownException;
import reactor.netty.internal.shaded.reactor.pool.PooledRef;
import reactor.netty.internal.shaded.reactor.pool.PooledRefMetadata;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class Http2Pool
implements InstrumentedPool<Connection>,
InstrumentedPool.PoolMetrics {
    static final Logger log = Loggers.getLogger(Http2Pool.class);
    volatile int acquired;
    static final AtomicIntegerFieldUpdater<Http2Pool> ACQUIRED = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "acquired");
    volatile ConcurrentLinkedQueue<Slot> connections;
    static final AtomicReferenceFieldUpdater<Http2Pool, ConcurrentLinkedQueue> CONNECTIONS = AtomicReferenceFieldUpdater.newUpdater(Http2Pool.class, ConcurrentLinkedQueue.class, "connections");
    volatile ConcurrentLinkedDeque<Borrower> pending;
    static final AtomicReferenceFieldUpdater<Http2Pool, ConcurrentLinkedDeque> PENDING = AtomicReferenceFieldUpdater.newUpdater(Http2Pool.class, ConcurrentLinkedDeque.class, "pending");
    static final ConcurrentLinkedDeque TERMINATED = new ConcurrentLinkedDeque();
    volatile int wip;
    static final AtomicIntegerFieldUpdater<Http2Pool> WIP = AtomicIntegerFieldUpdater.newUpdater(Http2Pool.class, "wip");
    final Clock clock;
    final long maxLifeTime;
    final PoolConfig<Connection> poolConfig;
    long lastInteractionTimestamp;

    Http2Pool(PoolConfig<Connection> poolConfig, long maxLifeTime) {
        if (poolConfig.allocationStrategy().getPermits(0) != 0) {
            throw new IllegalArgumentException("No support for configuring minimum number of connections");
        }
        this.clock = poolConfig.clock();
        this.connections = new ConcurrentLinkedQueue();
        this.lastInteractionTimestamp = this.clock.millis();
        this.maxLifeTime = maxLifeTime;
        this.pending = new ConcurrentLinkedDeque();
        this.poolConfig = poolConfig;
        this.recordInteractionTimestamp();
    }

    public Mono<PooledRef<Connection>> acquire() {
        return new BorrowerMono(this, Duration.ZERO);
    }

    public Mono<PooledRef<Connection>> acquire(Duration timeout) {
        return new BorrowerMono(this, timeout);
    }

    public int acquiredSize() {
        return this.acquired;
    }

    public int allocatedSize() {
        return this.acquired;
    }

    public PoolConfig<Connection> config() {
        return this.poolConfig;
    }

    public Mono<Void> disposeLater() {
        return Mono.defer(() -> {
            this.recordInteractionTimestamp();
            ConcurrentLinkedDeque q = PENDING.getAndSet(this, TERMINATED);
            if (q != TERMINATED) {
                Borrower p;
                while ((p = (Borrower)q.pollFirst()) != null) {
                    p.fail((Throwable)new PoolShutdownException());
                }
                CONNECTIONS.getAndSet(this, null);
            }
            return Mono.empty();
        });
    }

    public int getMaxAllocatedSize() {
        return Integer.MAX_VALUE;
    }

    public int getMaxPendingAcquireSize() {
        return this.poolConfig.maxPending() < 0 ? Integer.MAX_VALUE : this.poolConfig.maxPending();
    }

    public int idleSize() {
        return 0;
    }

    public boolean isDisposed() {
        return PENDING.get(this) == TERMINATED || CONNECTIONS.get(this) == null;
    }

    public boolean isInactiveForMoreThan(Duration duration) {
        return this.pendingAcquireSize() == 0 && this.allocatedSize() == 0 && this.secondsSinceLastInteraction() >= duration.getSeconds();
    }

    public InstrumentedPool.PoolMetrics metrics() {
        return this;
    }

    public int pendingAcquireSize() {
        return PENDING.get(this).size();
    }

    public long secondsSinceLastInteraction() {
        long sinceMs = this.clock.millis() - this.lastInteractionTimestamp;
        return sinceMs / 1000L;
    }

    public Mono<Integer> warmup() {
        return Mono.just((Object)0);
    }

    void cancelAcquire(Borrower borrower) {
        if (!this.isDisposed()) {
            ConcurrentLinkedDeque<Borrower> q = this.pending;
            q.remove(borrower);
        }
    }

    Mono<Void> destroyPoolable(Http2PooledRef ref) {
        Mono mono = Mono.empty();
        try {
            if (ref.slot.decrementConcurrencyAndGet() == 0) {
                ref.slot.invalidate();
                Connection connection = ref.poolable();
                Http2FrameCodec frameCodec = (Http2FrameCodec)connection.channel().pipeline().get(Http2FrameCodec.class);
                if (frameCodec != null) {
                    Http2Pool.releaseConnection(connection);
                }
            }
        }
        catch (Throwable destroyFunctionError) {
            mono = Mono.error((Throwable)destroyFunctionError);
        }
        return mono;
    }

    void doAcquire(Borrower borrower) {
        if (this.isDisposed()) {
            borrower.fail((Throwable)new PoolShutdownException());
            return;
        }
        this.pendingOffer(borrower);
        this.drain();
    }

    void drain() {
        if (WIP.getAndIncrement(this) == 0) {
            this.drainLoop();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void drainLoop() {
        this.recordInteractionTimestamp();
        int maxPending = this.poolConfig.maxPending();
        while (true) {
            block14: {
                ConcurrentLinkedQueue resources = CONNECTIONS.get(this);
                ConcurrentLinkedDeque borrowers = PENDING.get(this);
                if (resources == null) return;
                if (borrowers == TERMINATED) {
                    return;
                }
                int borrowersCount = borrowers.size();
                if (borrowersCount != 0) {
                    Slot slot = this.findConnection(resources);
                    if (slot != null) {
                        Borrower borrower = (Borrower)borrowers.pollFirst();
                        if (borrower == null) {
                            resources.offer(slot);
                            continue;
                        }
                        if (this.isDisposed()) {
                            borrower.fail((Throwable)new PoolShutdownException());
                            return;
                        }
                        if (slot.incrementConcurrencyAndGet() > 1) {
                            borrower.stopPendingCountdown();
                            if (log.isDebugEnabled()) {
                                log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel activated"));
                            }
                            ACQUIRED.incrementAndGet(this);
                            slot.deactivate();
                            this.poolConfig.acquisitionScheduler().schedule(() -> borrower.deliver(new Http2PooledRef(slot)));
                            break block14;
                        } else {
                            borrowers.offerFirst(borrower);
                            continue;
                        }
                    }
                    int permits = this.poolConfig.allocationStrategy().getPermits(1);
                    if (permits <= 0) {
                        if (maxPending >= 0) {
                            borrowersCount = borrowers.size();
                            int toCull = borrowersCount - maxPending;
                            for (int i = 0; i < toCull; ++i) {
                                Borrower extraneous = (Borrower)borrowers.pollFirst();
                                if (extraneous == null) continue;
                                this.pendingAcquireLimitReached(extraneous, maxPending);
                            }
                        }
                    } else {
                        Borrower borrower = (Borrower)borrowers.pollFirst();
                        if (borrower == null) continue;
                        if (this.isDisposed()) {
                            borrower.fail((Throwable)new PoolShutdownException());
                            return;
                        }
                        borrower.stopPendingCountdown();
                        Mono allocator = this.poolConfig.allocator();
                        Mono primary = allocator.doOnEach(sig -> {
                            if (sig.isOnNext()) {
                                Connection newInstance = (Connection)sig.get();
                                assert (newInstance != null);
                                Slot newSlot = new Slot(this, newInstance);
                                if (log.isDebugEnabled()) {
                                    log.debug(ReactorNetty.format((Channel)newInstance.channel(), (String)"Channel activated"));
                                }
                                ACQUIRED.incrementAndGet(this);
                                newSlot.incrementConcurrencyAndGet();
                                newSlot.deactivate();
                                borrower.deliver(new Http2PooledRef(newSlot));
                            } else if (sig.isOnError()) {
                                Throwable error = sig.getThrowable();
                                assert (error != null);
                                this.poolConfig.allocationStrategy().returnPermits(1);
                                borrower.fail(error);
                            }
                        }).contextWrite((ContextView)borrower.currentContext());
                        primary.subscribe(alreadyPropagated -> {}, alreadyPropagatedOrLogged -> this.drain(), this::drain);
                    }
                }
            }
            if (WIP.decrementAndGet(this) == 0) break;
        }
        this.recordInteractionTimestamp();
    }

    @Nullable
    Slot findConnection(ConcurrentLinkedQueue<Slot> resources) {
        int resourcesCount = resources.size();
        while (resourcesCount > 0) {
            --resourcesCount;
            Slot slot = resources.poll();
            if (slot == null) continue;
            if (!slot.connection.channel().isActive()) {
                if (slot.concurrency() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel is closed, {} active streams"), new Object[]{slot.concurrency()});
                    }
                    resources.offer(slot);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Channel is closed, remove from pool"));
                }
                resources.remove(slot);
                continue;
            }
            if (this.maxLifeTime != -1L && slot.lifeTime() >= this.maxLifeTime) {
                if (slot.concurrency() > 0) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Max life time is reached, {} active streams"), new Object[]{slot.concurrency()});
                    }
                    resources.offer(slot);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Max life time is reached, remove from pool"));
                }
                resources.remove(slot);
                continue;
            }
            if (!slot.canOpenStream()) {
                resources.offer(slot);
                if (!log.isDebugEnabled()) continue;
                log.debug(ReactorNetty.format((Channel)slot.connection.channel(), (String)"Max active streams is reached"));
                continue;
            }
            return slot;
        }
        return null;
    }

    void pendingAcquireLimitReached(Borrower borrower, int maxPending) {
        if (maxPending == 0) {
            borrower.fail((Throwable)new PoolAcquirePendingLimitException(0, "No pending allowed and pool has reached allocation limit"));
        } else {
            borrower.fail((Throwable)new PoolAcquirePendingLimitException(maxPending));
        }
    }

    void pendingOffer(Borrower borrower) {
        int maxPending = this.poolConfig.maxPending();
        ConcurrentLinkedDeque<Borrower> pendingQueue = this.pending;
        if (pendingQueue == TERMINATED) {
            return;
        }
        pendingQueue.offerLast(borrower);
        int postOffer = pendingQueue.size();
        if (WIP.getAndIncrement(this) == 0) {
            ConcurrentLinkedQueue<Slot> ir = this.connections;
            if (maxPending >= 0 && postOffer > maxPending && ir.isEmpty() && this.poolConfig.allocationStrategy().estimatePermitCount() == 0) {
                Borrower toCull = pendingQueue.pollLast();
                if (toCull != null) {
                    this.pendingAcquireLimitReached(toCull, maxPending);
                }
                if (WIP.decrementAndGet(this) > 0) {
                    this.drainLoop();
                }
                return;
            }
            this.drainLoop();
        }
    }

    void recordInteractionTimestamp() {
        this.lastInteractionTimestamp = this.clock.millis();
    }

    static boolean offerSlot(Slot slot) {
        ConcurrentLinkedQueue q = CONNECTIONS.get(slot.pool);
        return q != null && q.offer(slot);
    }

    static void releaseConnection(Connection connection) {
        ChannelOperations ops = (ChannelOperations)connection.as(ChannelOperations.class);
        if (ops != null) {
            ops.listener().onStateChange((Connection)ops, ConnectionObserver.State.DISCONNECTING);
        } else if (connection instanceof ConnectionObserver) {
            ((ConnectionObserver)connection).onStateChange(connection, ConnectionObserver.State.DISCONNECTING);
        } else {
            connection.dispose();
        }
    }

    static void removeSlot(Slot slot) {
        ConcurrentLinkedQueue q = CONNECTIONS.get(slot.pool);
        if (q != null) {
            q.remove(slot);
        }
    }

    static final class Slot {
        volatile int concurrency;
        static final AtomicIntegerFieldUpdater<Slot> CONCURRENCY = AtomicIntegerFieldUpdater.newUpdater(Slot.class, "concurrency");
        final Connection connection;
        final long creationTimestamp;
        final Http2Pool pool;

        Slot(Http2Pool pool, Connection connection) {
            this.connection = connection;
            this.creationTimestamp = pool.clock.millis();
            this.pool = pool;
        }

        boolean canOpenStream() {
            Http2FrameCodec frameCodec = (Http2FrameCodec)this.connection.channel().pipeline().get(Http2FrameCodec.class);
            if (frameCodec != null) {
                int concurrency = this.concurrency;
                int maxActiveStreams = frameCodec.connection().local().maxActiveStreams();
                return concurrency < maxActiveStreams;
            }
            return false;
        }

        int concurrency() {
            return this.concurrency;
        }

        void deactivate() {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.connection.channel(), (String)"Channel deactivated"));
            }
            Http2Pool.offerSlot(this);
        }

        int decrementConcurrencyAndGet() {
            return CONCURRENCY.decrementAndGet(this);
        }

        int incrementConcurrencyAndGet() {
            return CONCURRENCY.incrementAndGet(this);
        }

        void invalidate() {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format((Channel)this.connection.channel(), (String)"Channel removed from pool"));
            }
            this.pool.poolConfig.allocationStrategy().returnPermits(1);
            Http2Pool.removeSlot(this);
        }

        long lifeTime() {
            return this.pool.clock.millis() - this.creationTimestamp;
        }
    }

    static final class Http2PooledRef
    extends AtomicBoolean
    implements PooledRef<Connection>,
    PooledRefMetadata {
        final int acquireCount;
        final Slot slot;

        Http2PooledRef(Slot slot) {
            this.acquireCount = 0;
            this.slot = slot;
        }

        public int acquireCount() {
            return 1;
        }

        public long allocationTimestamp() {
            return 0L;
        }

        public long idleTime() {
            return 0L;
        }

        public Mono<Void> invalidate() {
            return Mono.defer(() -> {
                if (this.compareAndSet(false, true)) {
                    ACQUIRED.decrementAndGet(this.slot.pool);
                    return this.slot.pool.destroyPoolable(this).doFinally(st -> this.slot.pool.drain());
                }
                return Mono.empty();
            });
        }

        public long lifeTime() {
            return 0L;
        }

        public PooledRefMetadata metadata() {
            return this;
        }

        public Connection poolable() {
            return this.slot.connection;
        }

        public Mono<Void> release() {
            return this.invalidate();
        }

        public long releaseTimestamp() {
            return 0L;
        }

        @Override
        public String toString() {
            return "PooledRef{poolable=" + this.slot.connection + '}';
        }
    }

    static final class BorrowerMono
    extends Mono<PooledRef<Connection>> {
        final Duration acquireTimeout;
        final Http2Pool parent;

        BorrowerMono(Http2Pool pool, Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            this.parent = pool;
        }

        public void subscribe(CoreSubscriber<? super PooledRef<Connection>> actual) {
            Objects.requireNonNull(actual, "subscribing with null");
            Borrower borrower = new Borrower(actual, this.parent, this.acquireTimeout);
            actual.onSubscribe((Subscription)borrower);
        }
    }

    static final class Borrower
    extends AtomicBoolean
    implements Scannable,
    Subscription,
    Runnable {
        static final Disposable TIMEOUT_DISPOSED = Disposables.disposed();
        final Duration acquireTimeout;
        final CoreSubscriber<? super Http2PooledRef> actual;
        final Http2Pool pool;
        Disposable timeoutTask;

        Borrower(CoreSubscriber<? super Http2PooledRef> actual, Http2Pool pool, Duration acquireTimeout) {
            this.acquireTimeout = acquireTimeout;
            this.actual = actual;
            this.pool = pool;
            this.timeoutTask = TIMEOUT_DISPOSED;
        }

        public void cancel() {
            this.stopPendingCountdown();
            if (this.compareAndSet(false, true)) {
                this.pool.cancelAcquire(this);
            }
        }

        Context currentContext() {
            return this.actual.currentContext();
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                if (!this.acquireTimeout.isZero()) {
                    this.timeoutTask = Schedulers.parallel().schedule((Runnable)this, this.acquireTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
                this.pool.doAcquire(this);
            }
        }

        @Override
        public void run() {
            if (this.compareAndSet(false, true)) {
                this.pool.cancelAcquire(this);
                this.actual.onError((Throwable)new PoolAcquireTimeoutException(this.acquireTimeout));
            }
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.CANCELLED) {
                return this.get();
            }
            if (key == Scannable.Attr.REQUESTED_FROM_DOWNSTREAM) {
                return 1;
            }
            if (key == Scannable.Attr.ACTUAL) {
                return this.actual;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.get() ? "Borrower(cancelled)" : "Borrower";
        }

        void deliver(Http2PooledRef poolSlot) {
            this.stopPendingCountdown();
            if (this.get()) {
                poolSlot.invalidate().subscribe(aVoid -> {}, e -> Operators.onErrorDropped((Throwable)e, (Context)Context.empty()));
            } else {
                this.actual.onNext((Object)poolSlot);
                this.actual.onComplete();
            }
        }

        void fail(Throwable error) {
            this.stopPendingCountdown();
            if (!this.get()) {
                this.actual.onError(error);
            }
        }

        void stopPendingCountdown() {
            this.timeoutTask.dispose();
        }
    }
}

