/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.thrift.async.handler;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.resource.log.PipeLogger;
import org.apache.iotdb.commons.pipe.sink.limiter.TsFileSendRateLimiter;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeTransferFilePieceReq;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.response.PipeTransferFilePieceResp;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeResourceMetrics;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeTsFileMemoryBlock;
import org.apache.iotdb.db.pipe.sink.client.IoTDBDataNodeAsyncClientManager;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealReq;
import org.apache.iotdb.db.pipe.sink.payload.evolvable.request.PipeTransferTsFileSealWithModReq;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.IoTDBDataRegionAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.thrift.async.handler.PipeTransferTrackableHandler;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTsFileHandler
extends PipeTransferTrackableHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTsFileHandler.class);
    private final Map<Pair<String, Long>, Double> pipeName2WeightMap;
    private final List<EnrichedEvent> events;
    private final AtomicInteger eventsReferenceCount;
    private final AtomicBoolean eventsHadBeenAddedToRetryQueue;
    private final File tsFile;
    private final File modFile;
    private File currentFile;
    private final boolean transferMod;
    private final int readFileBufferSize;
    private PipeTsFileMemoryBlock memoryBlock;
    private byte[] readBuffer;
    private long position;
    private RandomAccessFile reader;
    private final AtomicBoolean isSealSignalSent;
    private IoTDBDataNodeAsyncClientManager clientManager;

    public PipeTransferTsFileHandler(IoTDBDataRegionAsyncSink connector, Map<Pair<String, Long>, Double> pipeName2WeightMap, List<EnrichedEvent> events, AtomicInteger eventsReferenceCount, AtomicBoolean eventsHadBeenAddedToRetryQueue, File tsFile, File modFile, boolean transferMod) throws InterruptedException {
        super(connector);
        this.pipeName2WeightMap = pipeName2WeightMap;
        this.events = events;
        this.eventsReferenceCount = eventsReferenceCount;
        this.eventsHadBeenAddedToRetryQueue = eventsHadBeenAddedToRetryQueue;
        this.tsFile = tsFile;
        this.modFile = modFile;
        this.transferMod = transferMod;
        this.currentFile = transferMod ? modFile : tsFile;
        this.waitForResourceEnough4Slicing((long)((1.0 + Math.random()) * 20.0 * 1000.0));
        this.readFileBufferSize = (int)Math.min((long)PipeConfig.getInstance().getPipeConnectorReadFileBufferSize(), transferMod ? Math.max(tsFile.length(), modFile.length()) : tsFile.length());
        this.position = 0L;
        this.isSealSignalSent = new AtomicBoolean(false);
    }

    public File getTsFile() {
        return this.tsFile;
    }

    public void transfer(IoTDBDataNodeAsyncClientManager clientManager, AsyncPipeDataTransferServiceClient client) throws TException, IOException {
        int readLength;
        if (this.readBuffer == null) {
            this.memoryBlock = PipeDataNodeResourceManager.memory().forceAllocateForTsFileWithRetry(PipeConfig.getInstance().isPipeConnectorReadFileBufferMemoryControlEnabled() ? (long)this.readFileBufferSize : 0L);
            this.readBuffer = new byte[this.readFileBufferSize];
        }
        if (this.reader == null) {
            this.reader = Objects.nonNull(this.modFile) ? new RandomAccessFile(this.modFile, "r") : new RandomAccessFile(this.tsFile, "r");
        }
        this.clientManager = clientManager;
        this.client = client;
        if (client == null) {
            LOGGER.warn("Client has been returned to the pool. Current handler status is {}. Will not transfer {}.", (Object)(this.connector.isClosed() ? "CLOSED" : "NOT CLOSED"), (Object)this.tsFile);
            return;
        }
        client.setShouldReturnSelf(false);
        client.setTimeoutDynamically(clientManager.getConnectionTimeout());
        PipeResourceMetrics.getInstance().recordDiskIO(this.readFileBufferSize);
        if (this.connector.isEnableSendTsFileLimit()) {
            TsFileSendRateLimiter.getInstance().acquire((long)this.readFileBufferSize);
        }
        if ((readLength = this.reader.read(this.readBuffer)) == -1) {
            if (this.currentFile == this.modFile) {
                this.currentFile = this.tsFile;
                this.position = 0L;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to close file reader when successfully transferred mod file.", (Throwable)e);
                }
                this.reader = new RandomAccessFile(this.tsFile, "r");
                this.transfer(clientManager, client);
            } else if (this.currentFile == this.tsFile) {
                this.isSealSignalSent.set(true);
                PipeTransferTsFileSealReq uncompressedReq = this.transferMod ? PipeTransferTsFileSealWithModReq.toTPipeTransferReq(this.modFile.getName(), this.modFile.length(), this.tsFile.getName(), this.tsFile.length()) : PipeTransferTsFileSealReq.toTPipeTransferReq(this.tsFile.getName(), this.tsFile.length());
                TPipeTransferReq req = this.connector.compressIfNeeded((TPipeTransferReq)uncompressedReq);
                this.pipeName2WeightMap.forEach((pipePair, weight) -> this.connector.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), client.getEndPoint(), (long)((double)req.getBody().length * weight)));
                if (!this.tryTransfer(client, req)) {
                    return;
                }
            }
            return;
        }
        byte[] payload = readLength == this.readFileBufferSize ? this.readBuffer : Arrays.copyOfRange(this.readBuffer, 0, readLength);
        PipeTransferFilePieceReq uncompressedReq = this.transferMod ? PipeTransferTsFilePieceWithModReq.toTPipeTransferReq(this.currentFile.getName(), this.position, payload) : PipeTransferTsFilePieceReq.toTPipeTransferReq(this.currentFile.getName(), this.position, payload);
        TPipeTransferReq req = this.connector.compressIfNeeded((TPipeTransferReq)uncompressedReq);
        this.pipeName2WeightMap.forEach((pipePair, weight) -> this.connector.rateLimitIfNeeded((String)pipePair.getLeft(), (Long)pipePair.getRight(), client.getEndPoint(), (long)((double)req.getBody().length * weight)));
        if (!this.tryTransfer(client, req)) {
            return;
        }
        this.position += (long)readLength;
    }

    @Override
    public void onComplete(TPipeTransferResp response) {
        try {
            super.onComplete(response);
        }
        finally {
            if (this.connector.isClosed()) {
                this.returnClientIfNecessary();
            }
        }
    }

    @Override
    protected boolean onCompleteInternal(TPipeTransferResp response) {
        block23: {
            int referenceCount;
            block21: {
                if (!this.isSealSignalSent.get()) break block23;
                try {
                    TSStatus status = response.getStatus();
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                        this.connector.statusHandler().handle(status, String.format("Seal file %s error, result status %s.", this.tsFile, response.getStatus()), this.tsFile.getName());
                    }
                }
                catch (Exception e) {
                    this.onError(e);
                    return false;
                }
                try {
                    if (this.reader != null) {
                        this.reader.close();
                    }
                    if (this.events.stream().anyMatch(event -> !(event instanceof PipeTsFileInsertionEvent))) {
                        RetryUtils.retryOnException(() -> {
                            FileUtils.delete((File)this.currentFile);
                            return null;
                        });
                    }
                    if ((referenceCount = this.eventsReferenceCount.decrementAndGet()) > 0) break block21;
                }
                catch (IOException e) {
                    int referenceCount2;
                    block22: {
                        try {
                            LOGGER.warn("Failed to close file reader or delete tsFile when successfully transferred file.", (Throwable)e);
                            referenceCount2 = this.eventsReferenceCount.decrementAndGet();
                            if (referenceCount2 > 0) break block22;
                        }
                        catch (Throwable throwable) {
                            int referenceCount3 = this.eventsReferenceCount.decrementAndGet();
                            if (referenceCount3 <= 0) {
                                this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
                            }
                            if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                                LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitIds).collect(Collectors.toList()), referenceCount3});
                            } else {
                                LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount3);
                            }
                            this.returnClientIfNecessary();
                            throw throwable;
                        }
                        this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
                    }
                    if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                        LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitIds).collect(Collectors.toList()), referenceCount2});
                    } else {
                        LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount2);
                    }
                    this.returnClientIfNecessary();
                }
                this.events.forEach(event -> event.decreaseReferenceCount(PipeTransferTsFileHandler.class.getName(), true));
            }
            if (this.events.size() <= 1 || LOGGER.isDebugEnabled()) {
                LOGGER.info("Successfully transferred file {} (committer key={}, commit id={}, reference count={}).", new Object[]{this.tsFile, this.events.stream().map(EnrichedEvent::getCommitterKey).collect(Collectors.toList()), this.events.stream().map(EnrichedEvent::getCommitIds).collect(Collectors.toList()), referenceCount});
            } else {
                LOGGER.info("Successfully transferred file {} (batched TableInsertionEvents, reference count={}).", (Object)this.tsFile, (Object)referenceCount);
            }
            this.returnClientIfNecessary();
            return true;
        }
        try {
            PipeTransferFilePieceResp resp = PipeTransferFilePieceResp.fromTPipeTransferResp((TPipeTransferResp)response);
            long code = resp.getStatus().getCode();
            if (code == (long)TSStatusCode.PIPE_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                this.position = resp.getEndWritingOffset();
                this.reader.seek(this.position);
                LOGGER.info("Redirect file position to {}.", (Object)this.position);
            } else {
                TSStatus status = response.getStatus();
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                    this.connector.statusHandler().handle(status, response.getStatus().getMessage(), this.tsFile.getName());
                }
            }
            this.transfer(this.clientManager, this.client);
        }
        catch (Exception e) {
            this.onError(e);
            return false;
        }
        return false;
    }

    @Override
    public void onError(Exception exception) {
        try {
            super.onError(exception);
        }
        finally {
            this.returnClientIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void onErrorInternal(Exception exception) {
        try {
            if (this.events.size() <= 1) ** GOTO lbl7
            if (PipeTransferTsFileHandler.LOGGER.isDebugEnabled()) {
lbl7:
                // 2 sources

                PipeLogger.log((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.String ), (Ljava/lang/String;)V)((Logger)PipeTransferTsFileHandler.LOGGER), (Throwable)exception, (String)"Failed to transfer TsFileInsertionEvent %s (committer key %s, commit id %s).", (Object[])new Object[]{this.tsFile, this.events.stream().map((Function<EnrichedEvent, CommitterKey>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCommitterKey(), (Lorg/apache/iotdb/commons/pipe/event/EnrichedEvent;)Lorg/apache/iotdb/commons/pipe/agent/task/progress/CommitterKey;)()).collect(Collectors.toList()), this.events.stream().map((Function<EnrichedEvent, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getCommitIds(), (Lorg/apache/iotdb/commons/pipe/event/EnrichedEvent;)Ljava/util/List;)()).collect(Collectors.toList())});
            } else {
                PipeLogger.log((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.String ), (Ljava/lang/String;)V)((Logger)PipeTransferTsFileHandler.LOGGER), (Throwable)exception, (String)"Failed to transfer TsFileInsertionEvent %s (batched TableInsertionEvents).", (Object[])new Object[]{this.tsFile});
            }
        }
        catch (Exception e) {
            PipeTransferTsFileHandler.LOGGER.warn("Failed to log error when failed to transfer file.", (Throwable)e);
        }
        try {
            if (Objects.nonNull(this.clientManager)) {
                this.clientManager.adjustTimeoutIfNecessary(exception);
            }
        }
        catch (Exception e) {
            PipeTransferTsFileHandler.LOGGER.warn("Failed to adjust timeout when failed to transfer file.", (Throwable)e);
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.events.stream().anyMatch((Predicate<EnrichedEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$onErrorInternal$5(org.apache.iotdb.commons.pipe.event.EnrichedEvent ), (Lorg/apache/iotdb/commons/pipe/event/EnrichedEvent;)Z)())) {
                RetryUtils.retryOnException((RetryUtils.CallableWithException)(RetryUtils.CallableWithException)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$onErrorInternal$6(), ()Ljava/lang/Object;)((PipeTransferTsFileHandler)this));
            }
        }
        catch (IOException e) {
            PipeTransferTsFileHandler.LOGGER.warn("Failed to close file reader or delete tsFile when failed to transfer file.", (Throwable)e);
        }
        finally {
            try {
                this.returnClientIfNecessary();
            }
            finally {
                if (this.eventsHadBeenAddedToRetryQueue.compareAndSet(false, true)) {
                    this.connector.addFailureEventsToRetryQueue(this.events);
                }
            }
        }
    }

    private void returnClientIfNecessary() {
        if (this.client == null) {
            return;
        }
        if (this.connector.isClosed()) {
            this.closeClient();
        }
        this.client.setShouldReturnSelf(true);
        this.client.returnSelf(e -> {
            if (e instanceof IllegalStateException) {
                LOGGER.info("Illegal state when return the client to object pool, maybe the pool is already cleared. Will ignore.");
                return true;
            }
            return false;
        });
        this.client = null;
    }

    @Override
    protected void doTransfer(AsyncPipeDataTransferServiceClient client, TPipeTransferReq req) throws TException {
        if (client == null) {
            LOGGER.warn("Client has been returned to the pool. Current handler status is {}. Will not transfer {}.", (Object)(this.connector.isClosed() ? "CLOSED" : "NOT CLOSED"), (Object)this.tsFile);
            return;
        }
        client.pipeTransfer(req, (AsyncMethodCallback)this);
    }

    @Override
    public void clearEventsReferenceCount() {
        this.events.forEach(event -> event.clearReferenceCount(PipeTransferTsFileHandler.class.getName()));
    }

    @Override
    public void close() {
        super.close();
        if (this.memoryBlock != null) {
            this.memoryBlock.close();
            this.memoryBlock = null;
        }
    }

    private void waitForResourceEnough4Slicing(long timeoutMs) throws InterruptedException {
        long currentTime;
        long startTime;
        if (!PipeConfig.getInstance().isPipeConnectorReadFileBufferMemoryControlEnabled()) {
            return;
        }
        PipeMemoryManager memoryManager = PipeDataNodeResourceManager.memory();
        if (memoryManager.isEnough4TsFileSlicing()) {
            return;
        }
        long lastRecordTime = startTime = System.currentTimeMillis();
        long memoryCheckIntervalMs = PipeConfig.getInstance().getPipeCheckMemoryEnoughIntervalMs();
        while (!memoryManager.isEnough4TsFileSlicing()) {
            Thread.sleep(memoryCheckIntervalMs);
            currentTime = System.currentTimeMillis();
            double elapsedRecordTimeSeconds = (double)(currentTime - lastRecordTime) / 1000.0;
            double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
            if (elapsedRecordTimeSeconds > 10.0) {
                LOGGER.info("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
                lastRecordTime = currentTime;
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
            }
            if (!(waitTimeSeconds * 1000.0 > (double)timeoutMs)) continue;
            throw new PipeException(String.format("TimeoutException: Waited %s seconds", waitTimeSeconds));
        }
        currentTime = System.currentTimeMillis();
        double waitTimeSeconds = (double)(currentTime - startTime) / 1000.0;
        LOGGER.info("Wait for resource enough for slicing tsfile {} for {} seconds.", (Object)this.tsFile, (Object)waitTimeSeconds);
    }

    private /* synthetic */ Object lambda$onErrorInternal$6() throws IOException {
        FileUtils.delete((File)this.currentFile);
        return null;
    }

    private static /* synthetic */ boolean lambda$onErrorInternal$5(EnrichedEvent event) {
        return !(event instanceof PipeTsFileInsertionEvent);
    }
}

