/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join.merge;

import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.ColumnMerger;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;

public class SingleColumnMerger
implements ColumnMerger {
    private final InputLocation location;
    private final TimeComparator comparator;

    public SingleColumnMerger(InputLocation location, TimeComparator comparator) {
        this.location = location;
        this.comparator = comparator;
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, TimeColumnBuilder timeBuilder, long currentEndTime, ColumnBuilder columnBuilder) {
        SingleColumnMerger.mergeOneColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeBuilder, currentEndTime, columnBuilder, this.location, this.comparator);
    }

    @Override
    public void mergeColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, long currentTime, ColumnBuilder columnBuilder) {
        SingleColumnMerger.mergeOneColumn(inputTsBlocks, inputIndex, updatedInputIndex, currentTime, columnBuilder, this.location);
    }

    public static void mergeOneColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, TimeColumnBuilder timeBuilder, long currentEndTime, ColumnBuilder columnBuilder, InputLocation location, TimeComparator comparator) {
        int tsBlockIndex = location.getTsBlockIndex();
        int columnIndex = location.getValueColumnIndex();
        int rowCount = timeBuilder.getPositionCount();
        int index = inputIndex[tsBlockIndex];
        if (ColumnMerger.empty(tsBlockIndex, inputTsBlocks, inputIndex) || !comparator.satisfyCurEndTime(inputTsBlocks[tsBlockIndex].getTimeByIndex(index), currentEndTime)) {
            columnBuilder.appendNull(rowCount);
        } else {
            TimeColumn timeColumn = inputTsBlocks[tsBlockIndex].getTimeColumn();
            Column valueColumn = inputTsBlocks[tsBlockIndex].getColumn(columnIndex);
            for (int i = 0; i < rowCount; ++i) {
                if (timeColumn.getPositionCount() == index || !comparator.satisfyCurEndTime(inputTsBlocks[tsBlockIndex].getTimeByIndex(index), currentEndTime)) {
                    columnBuilder.appendNull(rowCount - i);
                    break;
                }
                if (timeColumn.getLong(index) == timeBuilder.getTime(i)) {
                    if (valueColumn.isNull(index)) {
                        columnBuilder.appendNull();
                    } else {
                        columnBuilder.write(valueColumn, index);
                    }
                    ++index;
                    continue;
                }
                columnBuilder.appendNull();
            }
        }
        updatedInputIndex[tsBlockIndex] = index;
    }

    public static void mergeOneColumn(TsBlock[] inputTsBlocks, int[] inputIndex, int[] updatedInputIndex, long currentTime, ColumnBuilder columnBuilder, InputLocation location) {
        int tsBlockIndex = location.getTsBlockIndex();
        int columnIndex = location.getValueColumnIndex();
        int index = inputIndex[tsBlockIndex];
        if (ColumnMerger.empty(tsBlockIndex, inputTsBlocks, inputIndex) || inputTsBlocks[tsBlockIndex].getTimeByIndex(index) != currentTime) {
            columnBuilder.appendNull();
        } else {
            Column valueColumn = inputTsBlocks[tsBlockIndex].getColumn(columnIndex);
            if (valueColumn.isNull(index)) {
                columnBuilder.appendNull();
            } else {
                columnBuilder.write(valueColumn, index);
            }
        }
        updatedInputIndex[tsBlockIndex] = ++index;
    }
}

