/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log;

import java.io.File;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.tsfile.fileSystem.FSFactoryProducer;

public class TsFileIdentifier {
    private final String logicalStorageGroupName;
    private final String dataRegionId;
    private final String timePartitionId;
    private final boolean sequence;
    private String filename;
    public static final String INFO_SEPARATOR = " ";
    public static final int FILE_NAME_OFFSET_IN_PATH = 1;
    public static final int TIME_PARTITION_OFFSET_IN_PATH = 2;
    public static final int DATA_REGION_OFFSET_IN_PATH = 3;
    public static final int LOGICAL_SG_OFFSET_IN_PATH = 4;
    public static final int SEQUENCE_OFFSET_IN_PATH = 5;
    public static final int SEQUENCE_OFFSET_IN_LOG = 0;
    public static final int LOGICAL_SG_OFFSET_IN_LOG = 1;
    public static final int DATA_REGION_OFFSET_IN_LOG = 2;
    public static final int TIME_PARTITION_OFFSET_IN_LOG = 3;
    public static final int FILE_NAME_OFFSET_IN_LOG = 4;
    private static final String SEQUENCE_STR = "sequence";
    private static final String UNSEQUENCE_STR = "unsequence";

    private TsFileIdentifier(String logicalStorageGroupName, String dataRegionId, String timePartitionId, boolean sequence, String filename) {
        this.logicalStorageGroupName = logicalStorageGroupName;
        this.dataRegionId = dataRegionId;
        this.timePartitionId = timePartitionId;
        this.sequence = sequence;
        this.filename = filename;
    }

    public static TsFileIdentifier getFileIdentifierFromFilePath(String filepath) {
        String[] splittedPath;
        int length;
        String splitter = File.separator;
        if ("\\".equals(splitter)) {
            splitter = "\\\\";
        }
        if ((length = (splittedPath = filepath.split(splitter)).length) < 5) {
            throw new RuntimeException(String.format("Path %s cannot be parsed into file info", filepath));
        }
        return new TsFileIdentifier(splittedPath[length - 4], splittedPath[length - 3], splittedPath[length - 2], splittedPath[length - 5].equals(SEQUENCE_STR), splittedPath[length - 1]);
    }

    public static TsFileIdentifier getFileIdentifierFromInfoString(String infoString) {
        String[] splittedFileInfo = infoString.split(INFO_SEPARATOR);
        int length = splittedFileInfo.length;
        if (length != 5) {
            throw new RuntimeException(String.format("String %s is not a legal file info string", infoString));
        }
        return new TsFileIdentifier(splittedFileInfo[1], splittedFileInfo[2], splittedFileInfo[3], splittedFileInfo[0].equals(SEQUENCE_STR), splittedFileInfo[4]);
    }

    public String toString() {
        return String.format("%s%s%s%s%s%s%s%s%s", this.sequence ? SEQUENCE_STR : UNSEQUENCE_STR, INFO_SEPARATOR, this.logicalStorageGroupName, INFO_SEPARATOR, this.dataRegionId, INFO_SEPARATOR, this.timePartitionId, INFO_SEPARATOR, this.filename);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TsFileIdentifier)) {
            return false;
        }
        TsFileIdentifier otherInfo = (TsFileIdentifier)other;
        return otherInfo.sequence == this.sequence && otherInfo.logicalStorageGroupName.equals(this.logicalStorageGroupName) && otherInfo.dataRegionId.equals(this.dataRegionId) && otherInfo.timePartitionId.equals(this.timePartitionId) && otherInfo.filename.equals(this.filename);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public File getFileFromDataDirs() {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        String partialFileString = (this.sequence ? SEQUENCE_STR : UNSEQUENCE_STR) + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId + File.separator + this.timePartitionId + File.separator + this.filename;
        for (String dataDir : dataDirs) {
            File file = FSFactoryProducer.getFSFactory().getFile(dataDir, partialFileString);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public File getFileFromDataDirsIfAnyAdjuvantFileExists() {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        String partialFileString = (this.sequence ? SEQUENCE_STR : UNSEQUENCE_STR) + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId + File.separator + this.timePartitionId + File.separator + this.filename;
        for (String dataDir : dataDirs) {
            File file = FSFactoryProducer.getFSFactory().getFile(dataDir, partialFileString);
            if (!file.exists() && !new File(file.getAbsolutePath() + ".resource").exists() && !new File(file.getAbsolutePath() + ".mods").exists() && !new File(file.getAbsolutePath() + ".compaction.mods").exists()) continue;
            return file;
        }
        return null;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilePath() {
        return (this.sequence ? SEQUENCE_STR : UNSEQUENCE_STR) + File.separator + this.logicalStorageGroupName + File.separator + this.dataRegionId + File.separator + this.timePartitionId + File.separator + this.filename;
    }

    public String getLogicalStorageGroupName() {
        return this.logicalStorageGroupName;
    }

    public String getDataRegionId() {
        return this.dataRegionId;
    }

    public String getTimePartitionId() {
        return this.timePartitionId;
    }

    public boolean isSequence() {
        return this.sequence;
    }
}

