/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.tx;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearTxLocal;
import org.apache.ignite.transactions.TransactionState;

public class ClientTxContext {
    private final int txId;
    private final GridNearTxLocal tx;
    private final Lock lock = new ReentrantLock();

    public ClientTxContext(int txId, GridNearTxLocal tx) {
        assert (txId != 0);
        assert (tx != null);
        this.txId = txId;
        this.tx = tx;
    }

    public void acquire(boolean resumeTx) throws IgniteCheckedException {
        this.lock.lock();
        if (resumeTx) {
            this.tx.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean suspendTx) throws IgniteCheckedException {
        try {
            try {
                TransactionState state;
                if (suspendTx && (state = this.tx.state()) == TransactionState.ACTIVE) {
                    this.tx.suspend();
                }
            }
            finally {
                this.tx.context().tm().clearThreadMap(this.tx);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public int txId() {
        return this.txId;
    }

    public GridNearTxLocal tx() {
        return this.tx;
    }

    public void close() {
        this.lock.lock();
        try {
            this.tx.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
        }
    }
}

