/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted.inline.types;

import org.apache.ignite.internal.cache.query.index.sorted.IndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.inline.types.NumericInlineIndexKeyType;
import org.apache.ignite.internal.cache.query.index.sorted.keys.ByteIndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.cache.query.index.sorted.keys.NumericIndexKey;
import org.apache.ignite.internal.pagemem.PageUtils;

public class ByteInlineIndexKeyType
extends NumericInlineIndexKeyType<ByteIndexKey> {
    public ByteInlineIndexKeyType() {
        super(IndexKeyType.BYTE, (short)1);
    }

    @Override
    public int compare0(long pageAddr, int off, IndexKey key) {
        byte val = PageUtils.getByte(pageAddr, off + 1);
        return -Integer.signum(((NumericIndexKey)key).compareTo(val));
    }

    @Override
    protected int put0(long pageAddr, int off, ByteIndexKey key, int maxSize) {
        PageUtils.putByte(pageAddr, off, (byte)this.type().code());
        PageUtils.putByte(pageAddr, off + 1, (Byte)key.key());
        return this.keySize + 1;
    }

    @Override
    protected ByteIndexKey get0(long pageAddr, int off) {
        byte b = PageUtils.getByte(pageAddr, off + 1);
        return new ByteIndexKey(b);
    }
}

