/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.TreeIndex;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeCondition;
import org.apache.ignite3.internal.sql.engine.exec.exp.RangeIterable;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.FilteringIterator;
import org.apache.ignite3.internal.util.TransformingIterator;

public abstract class AbstractIndexScan<RowT, IdxRowT>
implements Iterable<RowT>,
AutoCloseable {
    private final TreeIndex<IdxRowT> idx;
    private final Predicate<RowT> filters;
    private final RangeIterable<RowT> ranges;
    private final Function<RowT, RowT> rowTransformer;
    protected final ExecutionContext<RowT> ectx;
    protected final RelDataType rowType;

    AbstractIndexScan(ExecutionContext<RowT> ectx, RelDataType rowType, TreeIndex<IdxRowT> idx, Predicate<RowT> filters, RangeIterable<RowT> ranges, Function<RowT, RowT> rowTransformer) {
        this.ectx = ectx;
        this.rowType = rowType;
        this.idx = idx;
        this.filters = filters;
        this.ranges = ranges;
        this.rowTransformer = rowTransformer;
    }

    @Override
    public synchronized Iterator<RowT> iterator() {
        Iterator it;
        if (this.ranges == null) {
            Cursor<Object> cursor = this.idx.find(null, null, true, true);
            TransformingIterator<RowT, RowT> it2 = new TransformingIterator<RowT, RowT>(cursor, this::indexRow2Row);
            it2 = this.filters != null ? new FilteringIterator<RowT>(it2, this.filters) : it2;
            return this.rowTransformer != null ? new TransformingIterator<RowT, RowT>(it2, this.rowTransformer) : it2;
        }
        if (!this.ranges.multiBounds() && !(it = this.ranges.iterator()).hasNext()) {
            return Collections.emptyIterator();
        }
        Iterable[] iterables = (Iterable[])Streams.stream(this.ranges).map(range -> new Iterable<RowT>(){
            final /* synthetic */ RangeCondition val$range;
            {
                this.val$range = rangeCondition;
            }

            @Override
            public Iterator<RowT> iterator() {
                Object lower = AbstractIndexScan.this.row2indexRow(this.val$range.lower());
                Object upper = AbstractIndexScan.this.row2indexRow(this.val$range.upper());
                Cursor cursor = AbstractIndexScan.this.idx.find(lower, upper, this.val$range.lowerInclude(), this.val$range.upperInclude());
                TransformingIterator it = new TransformingIterator(cursor, AbstractIndexScan.this::indexRow2Row);
                it = AbstractIndexScan.this.filters != null ? new FilteringIterator(it, AbstractIndexScan.this.filters) : it;
                return AbstractIndexScan.this.rowTransformer != null ? new TransformingIterator(it, AbstractIndexScan.this.rowTransformer) : it;
            }
        }).toArray(Iterable[]::new);
        return CollectionUtils.concat(iterables).iterator();
    }

    protected abstract IdxRowT row2indexRow(RowT var1);

    protected abstract RowT indexRow2Row(IdxRowT var1) throws IgniteInternalException;

    @Override
    public void close() {
    }
}

