<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Tutoriel du serveur HTTP Apache : fichiers .htaccess - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Recettes / Tutoriels</a></div><div id="page-content"><div id="preamble"><h1>Tutoriel du serveur HTTP Apache : fichiers .htaccess</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/howto/htaccess.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/htaccess.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/htaccess.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/htaccess.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../pt-br/howto/htaccess.html" hreflang="pt-br" rel="alternate" title="Portugus (Brasil)">&nbsp;pt-br&nbsp;</a></p>
</div>

<p>Les fichiers <code>.htaccess</code> fournissent une mthode pour
modifier la configuration du serveur au niveau de chaque rpertoire.</p>
</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#related">Fichiers .htaccess</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#what">Que sont ce fichiers, comment les utiliser ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#when">Quand doit-on (ne doit-on pas) utiliser
    les fichiers .htaccess ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#how">Comment sont appliques les directives ?</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#auth">Exemple d'authentification</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssi">Exemple d'Inclusion Ct Serveur (Server Side
Includes - SSI)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#cgi">Exemple de CGI</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#troubleshoot">Rsolution des problmes</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="related" id="related">Fichiers .htaccess</a></h2>
    
    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="../mod/core.html">core</a></code></li><li><code class="module"><a href="../mod/mod_authn_file.html">mod_authn_file</a></code></li><li><code class="module"><a href="../mod/mod_authz_groupfile.html">mod_authz_groupfile</a></code></li><li><code class="module"><a href="../mod/mod_cgi.html">mod_cgi</a></code></li><li><code class="module"><a href="../mod/mod_include.html">mod_include</a></code></li><li><code class="module"><a href="../mod/mod_mime.html">mod_mime</a></code></li></ul></td><td><ul><li><code class="directive"><a href="../mod/core.html#accessfilename">AccessFileName</a></code></li><li><code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code></li><li><code class="directive"><a href="../mod/core.html#options">Options</a></code></li><li><code class="directive"><a href="../mod/mod_mime.html#addhandler">AddHandler</a></code></li><li><code class="directive"><a href="../mod/core.html#sethandler">SetHandler</a></code></li><li><code class="directive"><a href="../mod/mod_authn_core.html#authtype">AuthType</a></code></li><li><code class="directive"><a href="../mod/mod_authn_core.html#authname">AuthName</a></code></li><li><code class="directive"><a href="../mod/mod_authn_file.html#authuserfile">AuthUserFile</a></code></li><li><code class="directive"><a href="../mod/mod_authz_groupfile.html#authgroupfile">AuthGroupFile</a></code></li><li><code class="directive"><a href="../mod/mod_authz_core.html#require">Require</a></code></li></ul></td></tr></table>
    <div class="note">Les fichiers <code>.htaccess</code> ne doivent tre utiliss
    que si vous n'avez pas accs au fichier de configuration du serveur
    principal. L'utilisation des fichiers <code>.htaccess</code>
    ralentit le fonctionnement de votre serveur HTTP Apache. Il est toujours
    prfrable de dfinir les directives que vous pouvez inclure dans un
    fichier <code>.htaccess</code> dans une section <code class="directive"><a href="../mod/core.html#directory">Directory</a></code>, car elles produiront le
    mme effet avec de meilleures performances.</div>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="what" id="what">Que sont ce fichiers, comment les utiliser ?</a></h2>


    <p>Les fichiers <code>.htaccess</code> (ou "fichiers de
    configuration distribus") fournissent une mthode pour modifier la
    configuration du serveur au niveau d'un rpertoire. Un fichier,
    contenant une ou plusieurs directives de configuration, est plac
    dans un rpertoire de documents particulier, et ses directives
    s'appliquent  ce rpertoire et  tous ses sous-rpertoires.</p>

    <div class="note"><h3>Note :</h3>
      <p>Si vous voulez donner un autre nom  votre fichier
      <code>.htaccess</code>, vous pouvez le faire en utilisant la
      directive <code class="directive"><a href="../mod/core.html#accessfilename">AccessFileName</a></code>. Par
      exemple, si vous prfrez nommer votre fichier
      <code>.config</code>, vous pouvez mettre ceci dans le fichier de
      configuration de votre serveur :</p>

      <pre class="prettyprint lang-config">AccessFileName .config</pre>

    </div>

    <p>En gnral, les fichiers <code>.htaccess</code> utilisent la mme
    syntaxe que les <a href="../configuring.html#syntax">fichiers de
    configuration principaux</a>. Ce que vous pouvez mettre dans ces
    fichier est dtermin par la directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>. Cette directive spcifie,
    sous forme de catgories, quelles directives seront traites si
    elles se trouvent dans un fichier <code>.htaccess</code>. Si une
    directive est permise dans un fichier <code>.htaccess</code> file,
    la documentation de cette directive contiendra une section Override,
    spcifiant quelle valeur doit prendre <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code> pour que cette directive
    soit traite.</p>

    <p>Par exemple, si vous regardez la documentation de la directive
    <code class="directive"><a href="../mod/core.html#adddefaultcharset">AddDefaultCharset</a></code>, vous verrez
    que cette dernire est permise dans les fichiers
    <code>.htaccess</code> (Voir la ligne de contexte dans le rsum de
    la directive). La ligne <a href="../mod/directive-dict.html#Context">Override</a> indique
    <code>FileInfo</code>. Vous devez donc avoir au moins
    <code>AllowOverride FileInfo</code> pour que cette directive soit
    traite dans les fichiers <code>.htaccess</code>.</p>

    <div class="example"><h3>Exemple :</h3><table>
        <tr>
          <td><a href="../mod/directive-dict.html#Context">Contexte :</a></td>
          <td>configuration du serveur, serveur virtuel, directory, .htaccess</td>
        </tr>

        <tr>
          <td><a href="../mod/directive-dict.html#Override">Override:</a></td>
          <td>FileInfo</td>
        </tr>
      </table></div>

    <p>Si vous n'tes pas sr qu'une directive particulire soit permise
    dans un fichier <code>.htaccess</code>, lisez la documentation de
    cette directive, et consultez la ligne de contexte pour
    ".htaccess".</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="when" id="when">Quand doit-on (ne doit-on pas) utiliser
    les fichiers .htaccess ?</a></h2>

    <p>En principe, vous ne devriez utiliser les fichiers
    <code>.htaccess</code> que lorsque vous n'avez pas accs au fichier de
    configuration du serveur principal. Par exemple, la fausse
    ide
    selon laquelle l'authentification de l'utilisateur devrait toujours
    tre faite dans les fichiers <code>.htaccess</code> est trs
    rpandue. Il est aussi souvent avanc, ces dernires
    annes, que les directives de <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> doivent
    tre dfinies dans les fichiers <code>.htaccess</code>. Ceci est
    tout simplement faux. Vous pouvez configurer
    l'authentification des utilisateurs au niveau de la configuration du
    serveur principal, et c'est en fait cette mthode qui doit tre
    privilgie. De mme, les directives de
    <code>mod_rewrite</code> fonctionneront mieux,  de nombreux gards,
    dans le contexte du serveur principal.</p>

    <p>Les fichiers <code>.htaccess</code> ne devraient tre utiliss
    que dans le cas o les fournisseurs de contenu ont besoin de
    modifier la configuration du serveur au niveau d'un rpertoire, mais
    ne possdent pas l'accs root sur le systme du serveur. Si
    l'administrateur du serveur ne souhaite pas effectuer des
    modifications de configuration incessantes, il peut tre intressant
    de permettre aux utilisateurs isols d'effectuer eux-mmes ces
    modifications par le biais de fichiers <code>.htaccess</code>. Ceci
    est particulirement vrai dans le cas o le fournisseur d'accs 
    Internet hberge de nombreux sites d'utilisateurs sur un seul
    serveur, et souhaite que ces utilisateurs puissent modifier
    eux-mmes leurs configurations.</p>

    <p>Cependant et d'une manire gnrale, il vaut mieux viter
    d'utiliser les fichiers <code>.htaccess</code>. Tout lment de
    configuration que vous pourriez vouloir mettre dans un fichier
    <code>.htaccess</code>, peut aussi tre mis, et avec la mme
    efficacit, dans une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> du fichier de configuration de
    votre serveur principal.</p>

    <p>Il y a deux raisons principales d'viter l'utilisation des
    fichiers <code>.htaccess</code>.</p>

    <p>La premire est lie aux performances. Lorsque la directive
    <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code> est dfinie de
    faon  autoriser l'utilisation des fichiers <code>.htaccess</code>,
    httpd va rechercher leur prsence dans chaque rpertoire. Ainsi,
    permettre l'utilisation des fichiers <code>.htaccess</code> est dj
    en soi une cause de dgradation des performances, que vous utilisiez
    effectivement ces fichiers ou non ! De plus, le fichier
    <code>.htaccess</code> est charg en mmoire chaque fois qu'un
    document fait l'objet d'une requte.</p>

    <p>Notez aussi que httpd doit rechercher les fichiers
    <code>.htaccess</code> dans tous les rpertoires de niveau
    suprieur, afin de rassembler toutes les directives qui s'appliquent
    au rpertoire courant (Voir la section <a href="#how">comment sont
    appliques les directives</a>). Ainsi, si un fichier fait l'objet
    d'une requte  partir d'un rpertoire
    <code>/www/htdocs/exemple</code>, httpd doit rechercher les
    fichiers suivants :</p>

    <div class="example"><p><code>
      /.htaccess<br />
      /www/.htaccess<br />
      /www/htdocs/.htaccess<br />
      /www/htdocs/exemple/.htaccess
    </code></p></div>

    <p>En consquence, chaque accs  un fichier de ce rpertoire
    ncessite 4 accs au systme de fichiers supplmentaires pour
    rechercher des fichiers <code>.htaccess</code>, mme si
    aucun de ces fichiers n'est prsent. Notez que cet exemple ne peut
    se produire que si les fichiers <code>.htaccess</code> ont t
    autoriss pour le rpertoire <code>/</code>, ce qui est rarement le
    cas.</p>

    <p>La seconde raison d'viter l'utilisation des fichiers
    <code>.htaccess</code> est lie  la scurit. Si vous permettez aux
    utilisateurs de modifier la configuration du serveur, il peut en
    rsulter des consquences sur lesquelles vous n'aurez aucun
    contrle. Rflchissez bien avant de donner ce privilge  vos
    utilisateurs. Notez aussi que ne pas donner aux utilisateurs les
    privilges dont ils ont besoin va entraner une augmentation des
    demandes de support technique. Assurez-vous d'avoir inform
    clairement vos utilisateurs du niveau de privilges que vous leur
    avez attribu. Indiquer exactement comment vous avez dfini la
    directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code> et
    diriger les utilisateurs vers la documentation correspondante vous
    vitera bien des confusions ultrieures.</p>

    <p>Notez que mettre un fichier <code>.htaccess</code> contenant une
    directive dans un rpertoire <code>/www/htdocs/exemple</code>
    revient exactement au mme que mettre la mme directive dans une
    section Directory <code>&lt;Directory /www/htdocs/exemple&gt;</code>
    du fichier de configuration de votre serveur principal :</p>

    <p>Fichier <code>.htaccess</code> dans
    <code>/www/htdocs/exemple</code> :</p>

    <div class="example"><h3>Contenu du fichier .htaccess dans
    <code>/www/htdocs/exemple</code></h3><pre class="prettyprint lang-config">AddType text/example .exm</pre>
</div>

    <div class="example"><h3>Section de votre fichier
    <code>httpd.conf</code></h3><pre class="prettyprint lang-config">&lt;Directory /www/htdocs/example&gt;
    AddType text/example .exm
&lt;/Directory&gt;</pre>
</div>

    <p>Cependant, la perte de performances sera moindre si vous
    dfinissez cette directive dans la configuration de
    votre serveur principal, car cette dernire ne sera charge qu'une
    seule fois au moment du dmarrage du serveur, alors qu'elle le sera
     chaque accs dans le cas d'un fichier <code>.htaccess</code>.</p>

    <p>L'utilisation des fichiers <code>.htaccess</code> peut tre
    entirement dsactive en dfinissant la directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>  <code>none</code> :</p>

    <pre class="prettyprint lang-config">AllowOverride None</pre>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="how" id="how">Comment sont appliques les directives ?</a></h2>

    <p>Les directives de configuration situes dans un fichier
    <code>.htaccess</code> s'appliquent au rpertoire dans lequel ce
    fichier <code>.htaccess</code> se trouve, ainsi qu' tous ses
    sous-rpertoires. Cependant, il est important de garder  l'esprit
    qu'il peut y avoir des fichiers <code>.htaccess</code> dans les
    rpertoires de niveau suprieur. Les directives sont appliques
    selon l'ordre dans lequel elles sont rencontres. Ainsi, les
    directives d'un fichier <code>.htaccess</code> situ dans un
    rpertoire particulier peuvent craser les directives se trouvant
    dans des fichiers <code>.htaccess</code> situs  un niveau
    suprieur dans l'arborescence des rpertoires. Et ces dernires
    peuvent elles-mmes avoir cras des directives d'un fichier
    <code>.htaccess</code> situ  un niveau encore plus haut, ou dans
    le fichier de configuration du serveur principal.</p>

    <p>Exemple :</p>

    <p>Dans le rpertoire <code>/www/htdocs/exemple1</code> se trouve un
    fichier <code>.htaccess</code> contenant ce qui suit :</p>

    <pre class="prettyprint lang-config">Options +ExecCGI</pre>


    <p>Note : "<code>AllowOverride Options</code>" doit tre prsent
    pour permettre l'utilisation de la directive "<code class="directive"><a href="../mod/core.html#options">Options</a></code>"  dans les fichiers
    <code>.htaccess</code>.</p>

    <p>Dans le rpertoire <code>/www/htdocs/exemple1/exemple2</code> se
    trouve un fichier <code>.htaccess</code> contenant ce qui suit
    :</p>

    <pre class="prettyprint lang-config">Options Includes</pre>


    <p>Ainsi,  cause de ce second fichier <code>.htaccess</code> du
    rpertoire <code>/www/htdocs/exemple1/exemple2</code>, l'excution
    des CGI est interdite, car la dernire dfinition d'options
    <code>Options Includes</code> crase toute autre dfinition
    d'options d'un fichier <code>.htaccess</code> situ dans un
    rpertoire de niveau suprieur.</p>

    <h3><a name="merge" id="merge">Interactions entre les fichiers .htaccess
    et les fichiers de configuration du serveur principal</a></h3>

    <p>Comme indiqu dans la documentation sur les <a href="../sections.html">Sections de configuration</a>, les fichiers
    <code>.htaccess</code> peuvent craser les directives des sections
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> pour
    le rpertoire correspondant, mais peuvent eux-mmes tre crass
    par d'autres types de sections des fichiers de la
    configuration principale. Cette possibilit peut s'avrer utile pour
    forcer certaines configurations, mme en cas de prsence de l'option
    librale <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>. Par
    exemple, pour interdire l'excution de scripts en autorisant la
    dfinition de toute autre option dans les fichiers
    <code>.htaccess</code>, vous pouvez utiliser :</p>

    <pre class="prettyprint lang-config">&lt;Directory /www/htdocs&gt;
    AllowOverride All
&lt;/Directory&gt;

&lt;Location /&gt;
    Options +IncludesNoExec -ExecCGI<br />
&lt;/Location&gt;</pre>


    <div class="note">Dans cet exemple, on considre que le chemin dfini par la
    directive <code class="directive"><a href="../mod/core.html#documentroot">DocumentRoot</a></code> est
    <code>/www/htdocs</code>.</div>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="auth" id="auth">Exemple d'authentification</a></h2>

    <p>Si vous accdez directement  ce point du document pour apprendre
     effectuer une authentification, il est important de noter ceci. Il
    existe une fausse ide selon laquelle il serait ncessaire
    d'utiliser les fichiers <code>.htaccess</code> pour implmenter
    l'authentification par mot de passe. Ceci est tout simplement faux.
    Pour y parvenir, il est prfrable de mettre les directives
    d'authentification dans une section <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> du fichier de configuration de
    votre serveur principal, et les fichiers <code>.htaccess</code> ne
    devraient tre utiliss que dans le cas o vous n'avez pas accs au
    fichier de configuration du serveur principal. Voir <a href="#when">ci-dessus</a> pour savoir dans quels cas vous devez ou
    ne devez pas utiliser les fichiers <code>.htaccess</code>.</p>

    <p>Ceci tant dit, si vous pensez que vous devez quand-mme utiliser
    un fichier <code>.htaccess</code>, vous pouvez utiliser la
    configuration suivante :</p>

    <p>Contenu du fichier <code>.htaccess</code> :</p>

    <pre class="prettyprint lang-config">AuthType Basic
AuthName "Password Required"
AuthUserFile /www/passwords/password.file
AuthGroupFile /www/passwords/group.file
Require Group admins</pre>


    <p>Notez que <code>AllowOverride AuthConfig</code> doit tre prsent
    pour que ces directives produisent leur effet.</p>

    <p>Vous pouvez vous rfrer au <a href="auth.html">tutoriel sur
    l'authentification</a> pour une description plus dtaille de
    l'authentification et de l'autorisation.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ssi" id="ssi">Exemple d'Inclusion Ct Serveur (Server Side
Includes - SSI)</a></h2>

    <p>Les fichiers <code>.htaccess</code> sont aussi couramment
    utiliss pour activer les SSI pour un rpertoire particulier. Pour y
    parvenir, on utilise les directives de configuration suivantes,
    places dans un fichier <code>.htaccess</code> enregistr dans le
    rpertoire considr :</p>

    <pre class="prettyprint lang-config">Options +Includes
AddType text/html shtml
AddHandler server-parsed shtml</pre>


    <p>Notez que <code>AllowOverride Options</code> et <code>AllowOverride
    FileInfo</code> doivent tre tous les deux prsents pour que ces
    directives puissent produire leur effet.</p>

    <p>Vous pouvez vous rfrer au <a href="ssi.html">tutoriel SSI</a>
    pour une description plus dtaille des SSI.</p>
</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cgi" id="cgi">Exemple de CGI</a></h2>

    <p>En fin de compte, vous avez dcid d'utiliser un fichier
    <code>.htaccess</code> pour permettre l'excution des programmes CGI
    dans un rpertoire particulier. Pour y parvenir, vous pouvez
    utiliser la configuration suivante :</p>

    <pre class="prettyprint lang-config">Options +ExecCGI
AddHandler cgi-script cgi pl</pre>


    <p>Alternativement, si vous souhaitez que tous les fichiers d'un
    rpertoire donn soient considrs comme des programmes CGI, vous
    pouvez utiliser la configuration suivante :</p>

    <pre class="prettyprint lang-config">Options +ExecCGI
SetHandler cgi-script</pre>


    <p>Notez que <code>AllowOverride Options</code> et <code>AllowOverride
    FileInfo</code> doivent tre tous les deux prsents pour que ces
    directives puissent produire leur effet.</p>

    <p>Vous pouvez vous rfrer au <a href="cgi.html">tutoriel CGI</a>
    pour une description plus dtaille de la configuration et de la
    proprammation CGI.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="troubleshoot" id="troubleshoot">Rsolution des problmes</a></h2>

    <p>De nombreuses raisons peuvent tre  l'origine du fait que
    les directives que vous avez mises dans un fichier
    <code>.htaccess</code> ne produisent pas l'effet dsir.</p>

    <p>Le plus souvent, le problme vient du fait que la dfinition de
    la directive <code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>
    ne permet pas l'activation des directives de votre fichier
    <code>.htaccess</code>. Vrifiez si une directive
    <code>AllowOverride None</code> n'affecte pas le rpertoire o se
    trouve votre fichier. Un bon test consiste  mettre des directives
    dont la syntaxe est errone dans votre ficher <code>.htaccess</code>
    et de recharger la page. Si aucune erreur n'est gnre par le
    serveur, il est pratiquement certain qu'une directive
    <code>AllowOverride None</code> affecte votre rpertoire.</p>

    <p>Par contre, si vous obtenez des erreurs de serveur lorsque vous
    tentez d'accder  des documents, consultez votre journal des
    erreurs de httpd. Il vous indiquera probablement que la directive
    utilise dans votre fichier <code>.htaccess</code> n'est pas
    permise.</p>

<div class="example"><p><code>
	[Fri Sep 17 18:43:16 2010] [alert] [client 192.168.200.51] /var/www/html/.htaccess: DirectoryIndex not allowed here
</code></p></div>
	<p>Cela signifie soit que vous utilisez une directive qui n'est
	jamais permise dans les fichiers <code>.htaccess</code>, soit
	que vous n'avez tout simplement pas dfini la directive
	<code class="directive"><a href="../mod/core.html#allowoverride">AllowOverride</a></code>  un niveau
	suffisant pour la directive que vous utilisez. Consultez la
	documentation de cette directive pour dterminer quel cas
	s'applique.</p>

	<p>Le journal des erreurs peut aussi vous signaler une erreur de
	syntaxe dans l'usage de la directive elle-mme.</p>

    <div class="example"><p><code>
    [Sat Aug 09 16:22:34 2008] [alert] [client 192.168.200.51] /var/www/html/.htaccess: RewriteCond: bad flag delimiters
    </code></p></div>

	<p>Dans ce cas, le message d'erreur sera spcifique  l'erreur
	de syntaxe que vous avez commise.</p>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/howto/htaccess.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/howto/htaccess.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/howto/htaccess.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a> |
<a href="../ko/howto/htaccess.html" hreflang="ko" rel="alternate" title="Korean">&nbsp;ko&nbsp;</a> |
<a href="../pt-br/howto/htaccess.html" hreflang="pt-br" rel="alternate" title="Portugus (Brasil)">&nbsp;pt-br&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/howto/htaccess.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>