/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableHistogramData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableSummaryData;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface MetricData {
    public Resource getResource();

    public InstrumentationScopeInfo getInstrumentationScopeInfo();

    public String getName();

    public String getDescription();

    public String getUnit();

    public MetricDataType getType();

    public Data<?> getData();

    default public boolean isEmpty() {
        return this.getData().getPoints().isEmpty();
    }

    default public GaugeData<DoublePointData> getDoubleGaugeData() {
        if (this.getType() == MetricDataType.DOUBLE_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public GaugeData<LongPointData> getLongGaugeData() {
        if (this.getType() == MetricDataType.LONG_GAUGE) {
            return (GaugeData)this.getData();
        }
        return ImmutableGaugeData.empty();
    }

    default public SumData<DoublePointData> getDoubleSumData() {
        if (this.getType() == MetricDataType.DOUBLE_SUM) {
            return (ImmutableSumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SumData<LongPointData> getLongSumData() {
        if (this.getType() == MetricDataType.LONG_SUM) {
            return (SumData)this.getData();
        }
        return ImmutableSumData.empty();
    }

    default public SummaryData getSummaryData() {
        if (this.getType() == MetricDataType.SUMMARY) {
            return (SummaryData)this.getData();
        }
        return ImmutableSummaryData.empty();
    }

    default public HistogramData getHistogramData() {
        if (this.getType() == MetricDataType.HISTOGRAM) {
            return (HistogramData)this.getData();
        }
        return ImmutableHistogramData.empty();
    }

    default public ExponentialHistogramData getExponentialHistogramData() {
        if (this.getType() == MetricDataType.EXPONENTIAL_HISTOGRAM) {
            return (ExponentialHistogramData)this.getData();
        }
        return ImmutableExponentialHistogramData.empty();
    }
}

