/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.nio.ByteBuffer;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactOperations;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketch;
import org.apache.datasketches.theta.DirectQuickSelectSketchR;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.SingleItemSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.thetacommon.QuickSelect;
import org.apache.datasketches.thetacommon.ThetaUtil;

final class UnionImpl
extends Union {
    private final UpdateSketch gadget_;
    private final short expectedSeedHash_;
    private long unionThetaLong_;
    private boolean unionEmpty_;

    private UnionImpl(UpdateSketch gadget, long seed) {
        this.gadget_ = gadget;
        this.expectedSeedHash_ = ThetaUtil.computeSeedHash(seed);
    }

    static UnionImpl initNewHeapInstance(int lgNomLongs, long seed, float p, ResizeFactor rf) {
        HeapQuickSelectSketch gadget = new HeapQuickSelectSketch(lgNomLongs, seed, p, rf, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((Sketch)gadget).isEmpty();
        return unionImpl;
    }

    static UnionImpl initNewDirectInstance(int lgNomLongs, long seed, float p, ResizeFactor rf, MemoryRequestServer memReqSvr, WritableMemory dstMem) {
        DirectQuickSelectSketch gadget = new DirectQuickSelectSketch(lgNomLongs, seed, p, rf, memReqSvr, dstMem, true);
        UnionImpl unionImpl = new UnionImpl(gadget, seed);
        unionImpl.unionThetaLong_ = ((Sketch)gadget).getThetaLong();
        unionImpl.unionEmpty_ = ((Sketch)gadget).isEmpty();
        return unionImpl;
    }

    static UnionImpl heapifyInstance(Memory srcMem, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        HeapQuickSelectSketch gadget = HeapQuickSelectSketch.heapifyInstance(srcMem, expectedSeed);
        UnionImpl unionImpl = new UnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcMem);
        return unionImpl;
    }

    static UnionImpl fastWrap(Memory srcMem, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketchR gadget = DirectQuickSelectSketchR.fastReadOnlyWrap(srcMem, expectedSeed);
        UnionImpl unionImpl = new UnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcMem);
        return unionImpl;
    }

    static UnionImpl fastWrap(WritableMemory srcMem, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID((Memory)srcMem));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.fastWritableWrap(srcMem, expectedSeed);
        UnionImpl unionImpl = new UnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong((Memory)srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag((Memory)srcMem);
        return unionImpl;
    }

    static UnionImpl wrapInstance(Memory srcMem, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID(srcMem));
        DirectQuickSelectSketchR gadget = DirectQuickSelectSketchR.readOnlyWrap(srcMem, expectedSeed);
        UnionImpl unionImpl = new UnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong(srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag(srcMem);
        return unionImpl;
    }

    static UnionImpl wrapInstance(WritableMemory srcMem, long expectedSeed) {
        Family.UNION.checkFamilyID(PreambleUtil.extractFamilyID((Memory)srcMem));
        DirectQuickSelectSketch gadget = DirectQuickSelectSketch.writableWrap(srcMem, expectedSeed);
        UnionImpl unionImpl = new UnionImpl(gadget, expectedSeed);
        unionImpl.unionThetaLong_ = PreambleUtil.extractUnionThetaLong((Memory)srcMem);
        unionImpl.unionEmpty_ = PreambleUtil.isEmptyFlag((Memory)srcMem);
        return unionImpl;
    }

    @Override
    public int getCurrentBytes() {
        return this.gadget_.getCurrentBytes();
    }

    @Override
    public int getMaxUnionBytes() {
        int lgK = this.gadget_.getLgNomLongs();
        return (16 << lgK) + (Family.UNION.getMaxPreLongs() << 3);
    }

    @Override
    public CompactSketch getResult() {
        return this.getResult(true, null);
    }

    @Override
    public CompactSketch getResult(boolean dstOrdered, WritableMemory dstMem) {
        int gadgetCurCount = this.gadget_.getRetainedEntries(true);
        int k = 1 << this.gadget_.getLgNomLongs();
        long[] gadgetCacheCopy = this.gadget_.hasMemory() ? this.gadget_.getCache() : (long[])this.gadget_.getCache().clone();
        long curGadgetThetaLong = this.gadget_.getThetaLong();
        long adjGadgetThetaLong = gadgetCurCount > k ? QuickSelect.selectExcludingZeros(gadgetCacheCopy, gadgetCurCount, k + 1) : curGadgetThetaLong;
        long unionThetaLong = this.gadget_.hasMemory() ? this.gadget_.getMemory().getLong(24L) : this.unionThetaLong_;
        long minThetaLong = Math.min(Math.min(curGadgetThetaLong, adjGadgetThetaLong), unionThetaLong);
        int curCountOut = minThetaLong < curGadgetThetaLong ? HashOperations.count(gadgetCacheCopy, minThetaLong) : gadgetCurCount;
        long[] compactCacheOut = CompactOperations.compactCache(gadgetCacheCopy, curCountOut, minThetaLong, dstOrdered);
        boolean empty = this.gadget_.isEmpty() && this.unionEmpty_;
        short seedHash = this.gadget_.getSeedHash();
        return CompactOperations.componentsToCompact(minThetaLong, curCountOut, seedHash, empty, true, dstOrdered, dstOrdered, dstMem, compactCacheOut);
    }

    @Override
    public boolean hasMemory() {
        return this.gadget_ instanceof DirectQuickSelectSketchR ? this.gadget_.hasMemory() : false;
    }

    @Override
    public boolean isDirect() {
        return this.gadget_ instanceof DirectQuickSelectSketchR ? this.gadget_.isDirect() : false;
    }

    @Override
    public boolean isSameResource(Memory that) {
        return this.gadget_ instanceof DirectQuickSelectSketchR ? this.gadget_.isSameResource(that) : false;
    }

    @Override
    public void reset() {
        this.gadget_.reset();
        this.unionThetaLong_ = this.gadget_.getThetaLong();
        this.unionEmpty_ = this.gadget_.isEmpty();
    }

    @Override
    public byte[] toByteArray() {
        byte[] gadgetByteArr = this.gadget_.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])gadgetByteArr);
        PreambleUtil.insertUnionThetaLong(mem, this.unionThetaLong_);
        if (this.gadget_.isEmpty() != this.unionEmpty_) {
            PreambleUtil.clearEmpty(mem);
            this.unionEmpty_ = false;
        }
        return gadgetByteArr;
    }

    @Override
    public CompactSketch union(Sketch sketchA, Sketch sketchB, boolean dstOrdered, WritableMemory dstMem) {
        this.reset();
        this.union(sketchA);
        this.union(sketchB);
        CompactSketch csk = this.getResult(dstOrdered, dstMem);
        this.reset();
        return csk;
    }

    @Override
    public void union(Sketch sketchIn) {
        if (sketchIn == null || sketchIn.isEmpty()) {
            return;
        }
        ThetaUtil.checkSeedHashes(this.expectedSeedHash_, sketchIn.getSeedHash());
        if (sketchIn instanceof SingleItemSketch) {
            this.gadget_.hashUpdate(sketchIn.getCache()[0]);
            return;
        }
        Sketch.checkSketchAndMemoryFlags(sketchIn);
        this.unionThetaLong_ = Math.min(Math.min(this.unionThetaLong_, sketchIn.getThetaLong()), this.gadget_.getThetaLong());
        this.unionEmpty_ = false;
        boolean isOrdered = sketchIn.isOrdered();
        HashIterator it = sketchIn.iterator();
        while (it.next()) {
            long hash = it.get();
            if (hash < this.unionThetaLong_ && hash < this.gadget_.getThetaLong()) {
                this.gadget_.hashUpdate(hash);
                continue;
            }
            if (!isOrdered) continue;
            break;
        }
        this.unionThetaLong_ = Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
        if (this.gadget_.hasMemory()) {
            WritableMemory wmem = (WritableMemory)this.gadget_.getMemory();
            PreambleUtil.insertUnionThetaLong(wmem, this.unionThetaLong_);
            PreambleUtil.clearEmpty(wmem);
        }
    }

    @Override
    public void union(Memory skMem) {
        if (skMem != null) {
            this.union(Sketch.wrap(skMem));
        }
    }

    @Override
    public void update(long datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(double datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(String datum) {
        this.gadget_.update(datum);
    }

    @Override
    public void update(byte[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(ByteBuffer data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(char[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(int[] data) {
        this.gadget_.update(data);
    }

    @Override
    public void update(long[] data) {
        this.gadget_.update(data);
    }

    @Override
    long[] getCache() {
        return this.gadget_.getCache();
    }

    @Override
    int getRetainedEntries() {
        return this.gadget_.getRetainedEntries(true);
    }

    @Override
    short getSeedHash() {
        return this.gadget_.getSeedHash();
    }

    @Override
    long getThetaLong() {
        return Math.min(this.unionThetaLong_, this.gadget_.getThetaLong());
    }

    @Override
    boolean isEmpty() {
        return this.gadget_.isEmpty() && this.unionEmpty_;
    }
}

