/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSketchSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllDoublesSketchTest {
    private static final String LS = System.getProperty("line.separator");
    private static final double PMF_EPS_FOR_K_8 = KllSketch.getNormalizedRankError((int)8, (boolean)true);
    private static final double PMF_EPS_FOR_K_128 = KllSketch.getNormalizedRankError((int)128, (boolean)true);
    private static final double PMF_EPS_FOR_K_256 = KllSketch.getNormalizedRankError((int)256, (boolean)true);
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(Double.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank(0.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(1.0);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(0.0, QuantileSearchCriteria.INCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(2.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
    }

    @Test
    public void tenValues() {
        int i;
        int i2;
        int i3;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)20);
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((double)i3);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank((double)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i3, QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        double[] qArr = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        for (i2 = 0; i2 >= 10; ++i2) {
            double rank = (double)i2 / 10.0;
            double q = rank == 1.0 ? (double)i2 : (double)(i2 + 1);
            Assert.assertEquals((double)sketch.getQuantile(rank, QuantileSearchCriteria.EXCLUSIVE), (double)q);
            q = rank == 0.0 ? (double)i2 + 1.0 : (double)i2;
            Assert.assertEquals((double)sketch.getQuantile(rank, QuantileSearchCriteria.INCLUSIVE), (double)q);
        }
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.EXCLUSIVE), (double)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (double)quantiles[i]);
        }
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((double)i), (double)trueRank, (double)PMF_EPS_FOR_K_256, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new double[]{500000.0});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)PMF_EPS_FOR_K_256);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)PMF_EPS_FOR_K_256);
        Assert.assertEquals((double)sketch.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch.getMaxItem(), (double)999999.0);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        double[] quantiles = sketch.getQuantiles(fractions);
        double[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        double previousQuantile = 0.0;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            double quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((double)quantile, (double)quantiles[i3]);
            Assert.assertEquals((double)quantile, (double)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        int i;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        int n = 1000;
        double[] values = new double[1000];
        for (int i2 = 0; i2 < 1000; ++i2) {
            sketch.update((double)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        pmf = sketch.getPMF(values, QuantileSearchCriteria.INCLUSIVE);
        sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i * 1.0);
            sketch2.update((double)(20000 - i - 1) * 1.0);
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)(20000.0 * PMF_EPS_FOR_K_256));
    }

    @Test
    public void mergeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)(20000 - i - 1));
        }
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)10000.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)19999.0);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)19999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)(20000.0 * PMF_EPS_FOR_K_128));
    }

    @Test
    public void mergeEmptyLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)(10000.0 * PMF_EPS_FOR_K_256));
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((double)sketch1.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch1.getMaxItem(), (double)9999.0);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)(10000.0 * PMF_EPS_FOR_K_256));
    }

    @Test
    public void mergeExactModeLowerK() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance((int)256);
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((double)i);
        }
        sketch2.update(1.0);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance();
        sketch1.update(1.0);
        sketch2.update(2.0);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllDoublesSketch sketch1 = KllDoublesSketch.newHeapInstance();
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((double)i);
        }
        KllDoublesSketch sketch2 = KllDoublesSketch.newHeapInstance((int)10);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((double)sketch2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1000000.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllDoublesSketch.newHeapInstance((int)7);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllDoublesSketch.newHeapInstance((int)65536);
    }

    @Test
    public void minK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)8);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)(1000.0 * PMF_EPS_FOR_K_8));
    }

    @Test
    public void maxK() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)65535);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)(1000.0 * PMF_EPS_FOR_K_256));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{1.0, 0.0});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        sketch.update(0.0);
        sketch.getCDF(new double[]{Double.NaN});
    }

    @Test
    public void checkReset() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n1 = sk.getN();
        double min1 = sk.getMinItem();
        double max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((double)i);
        }
        long n2 = sk.getN();
        double min2 = sk.getMinItem();
        double max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((double)min2, (double)min1);
        Assert.assertEquals((double)max2, (double)max1);
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        try {
            sk2.update(1.0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSize() {
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        KllDoublesSketch.newDirectInstance((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        try {
            KllDoublesSketch.newDirectInstance(null, (MemoryRequestServer)memReqSvr);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            KllDoublesSketch.newDirectInstance((WritableMemory)wmem, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int updateSize = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        int compactSize = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)false);
        Assert.assertTrue((compactSize < updateSize ? 1 : 0) != 0);
    }

    @Test
    public void sortedView() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(3.0);
        sk.update(1.0);
        sk.update(2.0);
        DoublesSketchSortedView view = sk.getSortedView();
        DoublesSortedViewIterator itr = view.iterator();
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)1.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)2.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((double)itr.getQuantile(), (double)3.0);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)2L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)itr.next(), (boolean)false);
    }

    @Test
    public void checkCDF_PDF() {
        int i;
        double[] cdfI = new double[]{0.25, 0.5, 0.75, 1.0, 1.0};
        double[] cdfE = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        double[] pmfI = new double[]{0.25, 0.25, 0.25, 0.25, 0.0};
        double[] pmfE = new double[]{0.0, 0.25, 0.25, 0.25, 0.25};
        double toll = 1.0E-10;
        KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance();
        double[] doublesIn = new double[]{10.0, 20.0, 30.0, 40.0};
        for (int i2 = 0; i2 < doublesIn.length; ++i2) {
            sketch.update(doublesIn[i2]);
        }
        double[] sp = new double[]{10.0, 20.0, 30.0, 40.0};
        KllDoublesSketchTest.println("SplitPoints:");
        for (int i3 = 0; i3 < sp.length; ++i3) {
            KllDoublesSketchTest.printf("%10.2f", sp[i3]);
        }
        KllDoublesSketchTest.println("");
        KllDoublesSketchTest.println("INCLUSIVE:");
        double[] cdf = sketch.getCDF(sp, QuantileSearchCriteria.INCLUSIVE);
        double[] pmf = sketch.getPMF(sp, QuantileSearchCriteria.INCLUSIVE);
        KllDoublesSketchTest.printf("%10s%10s" + LS, "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllDoublesSketchTest.printf("%10.2f%10.2f" + LS, cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfI[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfI[i], (double)1.0E-10);
        }
        KllDoublesSketchTest.println("EXCLUSIVE");
        cdf = sketch.getCDF(sp, QuantileSearchCriteria.EXCLUSIVE);
        pmf = sketch.getPMF(sp, QuantileSearchCriteria.EXCLUSIVE);
        KllDoublesSketchTest.printf("%10s%10s" + LS, "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllDoublesSketchTest.printf("%10.2f%10.2f" + LS, cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfE[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfE[i], (double)1.0E-10);
        }
    }

    @Test
    public void checkWrapCase1Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkWritableWrapCase6And2Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertFalse((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase5Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase3Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        WritableMemory wmem = (WritableMemory)mem;
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase7Doubles() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        WritableMemory wmem = (WritableMemory)mem;
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkReadOnlyExceptions() {
        int[] intArr = new int[]{};
        int intV = 2;
        int idx = 1;
        KllDoublesSketch sk1 = KllDoublesSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllDoublesSketch sk2 = KllDoublesSketch.wrap((Memory)mem);
        try {
            sk2.setLevelsArray(intArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelsArrayAt(idx, intV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsSameResource() {
        WritableMemory reg2;
        int cap = 128;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        WritableMemory reg1 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == (reg2 = wmem.writableRegion(64L, 64L)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)reg1.isSameResource((Resource)reg2));
        WritableMemory reg3 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == reg3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reg1.isSameResource((Resource)reg3));
        byte[] byteArr1 = KllDoublesSketch.newHeapInstance((int)20).toByteArray();
        reg1.putByteArray(0L, byteArr1, 0, byteArr1.length);
        KllDoublesSketch sk1 = KllDoublesSketch.wrap((Memory)reg1);
        byte[] byteArr2 = KllDoublesSketch.newHeapInstance((int)20).toByteArray();
        reg2.putByteArray(0L, byteArr2, 0, byteArr2.length);
        Assert.assertFalse((boolean)sk1.isSameResource((Memory)reg2));
        byte[] byteArr3 = KllDoublesSketch.newHeapInstance((int)20).toByteArray();
        reg3.putByteArray(0L, byteArr3, 0, byteArr3.length);
        Assert.assertTrue((boolean)sk1.isSameResource((Memory)reg3));
    }

    @Test
    public void checkSortedViewAfterReset() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        DoublesSketchSortedView sv = sk.getSortedView();
        double dsv = sv.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE);
        Assert.assertEquals((double)dsv, (double)1.0);
        sk.reset();
        try {
            sk.getSortedView();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkVectorUpdate() {
        int rem;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int k = 20;
        int n = 108;
        int maxVsz = 40;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        int j = 1;
        while ((rem = n - j + 1) > 0) {
            int vecSz = Math.min(rem, maxVsz);
            double[] v = new double[vecSz];
            for (int i = 0; i < vecSz; ++i) {
                v[i] = j++;
            }
            sk.update(v, 0, vecSz);
        }
        KllDoublesSketchTest.println(LS + "#<<< END STATE # >>>");
        KllDoublesSketchTest.println(sk.toString(withLevels, withLevelsAndItems));
        KllDoublesSketchTest.println("");
        Assert.assertEquals((long)sk.getN(), (long)108L);
        Assert.assertEquals((double)sk.getMaxItem(), (double)108.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
    }

    @Test
    public void vectorizedUpdates() {
        boolean trials = true;
        boolean M = true;
        int N = 1000;
        int K = 256;
        double[] values = new double[1000];
        double vIn = 1.0;
        long totN = 0L;
        long startTime = System.nanoTime();
        for (int t = 0; t < 1; ++t) {
            KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)256);
            for (int m = 0; m < 1; ++m) {
                for (int n = 0; n < 1000; ++n) {
                    vIn += 1.0;
                }
                sketch.update(values, 0, 1000);
            }
            totN = sketch.getN();
            Assert.assertEquals((long)totN, (long)1000L);
            Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)sketch.getMaxItem(), (double)totN);
            Assert.assertEquals((double)sketch.getQuantile(0.5), (double)((double)totN / 2.0), (double)((double)totN * PMF_EPS_FOR_K_256 * 2.0));
        }
        long runTime = System.nanoTime() - startTime;
        KllDoublesSketchTest.println("Vectorized Updates");
        KllDoublesSketchTest.printf("  Vector size : %,12d" + LS, 1000);
        KllDoublesSketchTest.printf("  Num Vectors : %,12d" + LS, 1);
        KllDoublesSketchTest.printf("  Total Input : %,12d" + LS, totN);
        KllDoublesSketchTest.printf("  Run Time mS : %,12.3f" + LS, (double)runTime / 1000000.0);
        double trialTime = (double)runTime / 1000000.0;
        KllDoublesSketchTest.printf("  mS / Trial  : %,12.3f" + LS, trialTime);
        double updateTime = (double)runTime / (1.0 * (double)totN * 1.0);
        KllDoublesSketchTest.printf("  nS / Update : %,12.3f" + LS, updateTime);
    }

    @Test
    public void nonVectorizedUpdates() {
        boolean trials = true;
        boolean M = true;
        int N = 1000;
        int K = 256;
        double[] values = new double[1000];
        double vIn = 1.0;
        long totN = 0L;
        long startTime = System.nanoTime();
        for (int t = 0; t < 1; ++t) {
            KllDoublesSketch sketch = KllDoublesSketch.newHeapInstance((int)256);
            for (int m = 0; m < 1; ++m) {
                for (int n = 0; n < 1000; ++n) {
                    vIn += 1.0;
                }
                for (int i = 0; i < 1000; ++i) {
                    sketch.update(values[i]);
                }
            }
            totN = sketch.getN();
            Assert.assertEquals((long)totN, (long)1000L);
            Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
            Assert.assertEquals((double)sketch.getMaxItem(), (double)totN);
            Assert.assertEquals((double)sketch.getQuantile(0.5), (double)((double)totN / 2.0), (double)((double)totN * PMF_EPS_FOR_K_256 * 2.0));
        }
        long runTime = System.nanoTime() - startTime;
        KllDoublesSketchTest.println("Vectorized Updates");
        KllDoublesSketchTest.printf("  Vector size : %,12d" + LS, 1000);
        KllDoublesSketchTest.printf("  Num Vectors : %,12d" + LS, 1);
        KllDoublesSketchTest.printf("  Total Input : %,12d" + LS, totN);
        KllDoublesSketchTest.printf("  Run Time mS : %,12.3f" + LS, (double)runTime / 1000000.0);
        double trialTime = (double)runTime / 1000000.0;
        KllDoublesSketchTest.printf("  mS / Trial  : %,12.3f" + LS, trialTime);
        double updateTime = (double)runTime / (1.0 * (double)totN * 1.0);
        KllDoublesSketchTest.printf("  nS / Update : %,12.3f" + LS, updateTime);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

