/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Comparator;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ItemsSketchIteratorTest {
    @Test
    public void emptySketch() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        QuantilesGenericSketchIterator it = sketch.iterator();
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void oneItemSketch() {
        ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
        sketch.update((Object)0);
        QuantilesGenericSketchIterator it = sketch.iterator();
        Assert.assertTrue((boolean)it.next());
        Assert.assertEquals((Integer)((Integer)it.getQuantile()), (Integer)0);
        Assert.assertEquals((long)it.getWeight(), (long)1L);
        Assert.assertFalse((boolean)it.next());
    }

    @Test
    public void bigSketches() {
        for (int n = 1000; n < 100000; n += 2000) {
            ItemsSketch sketch = ItemsSketch.getInstance(Integer.class, (int)128, Comparator.naturalOrder());
            for (int i = 0; i < n; ++i) {
                sketch.update((Object)i);
            }
            QuantilesGenericSketchIterator it = sketch.iterator();
            int count = 0;
            int weight = 0;
            while (it.next()) {
                ++count;
                weight += (int)it.getWeight();
            }
            Assert.assertEquals((int)count, (int)sketch.getNumRetained());
            Assert.assertEquals((int)weight, (int)n);
        }
    }
}

