/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanElaborator;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Aggregate;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;

public class Empty
extends Aggregate {
    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        VennExpression v;
        int c = arguments[0].getCardinality();
        if (!Cardinality.allowsZero(c)) {
            return Literal.makeLiteral(BooleanValue.FALSE, arguments[0]);
        }
        if (c == 8192) {
            return Literal.makeLiteral(BooleanValue.TRUE, arguments[0]);
        }
        Expression unorderedArg0 = arguments[0].unordered(false, visitor.isOptimizeForStreaming());
        if (unorderedArg0 != arguments[0]) {
            return this.makeFunctionCall(unorderedArg0);
        }
        if (arguments[0] instanceof VennExpression && !visitor.isOptimizeForStreaming() && (v = (VennExpression)arguments[0]).getOperator() == 1) {
            Expression e0 = SystemFunction.makeCall("empty", this.getRetainedStaticContext(), v.getLhsExpression());
            Expression e1 = SystemFunction.makeCall("empty", this.getRetainedStaticContext(), v.getRhsExpression());
            return new AndExpression(e0, e1).optimize(visitor, contextInfo);
        }
        return null;
    }

    @Override
    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        return BooleanValue.get(Empty.empty(arguments[0].iterate()));
    }

    private static boolean empty(SequenceIterator iter) {
        boolean result = iter instanceof LookaheadIterator && ((LookaheadIterator)iter).supportsHasNext() ? !((LookaheadIterator)iter).hasNext() : iter.next() == null;
        iter.close();
        return result;
    }

    @Override
    public String getStreamerName() {
        return "Empty";
    }

    @Override
    public Elaborator getElaborator() {
        return new EmptyFnElaborator();
    }

    private static class EmptyFnElaborator
    extends BooleanElaborator {
        private EmptyFnElaborator() {
        }

        @Override
        public BooleanEvaluator elaborateForBoolean() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            PullEvaluator puller = arg.makeElaborator().elaborateForPull();
            return context -> Empty.empty(puller.iterate(context));
        }
    }
}

