/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import com.typesafe.scalalogging.Logger;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Logger$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.RetryableException;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.Suspension;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface SuspendableOperation
extends Suspension {
    @Override
    public RuntimeData rd();

    public static String toString$(SuspendableOperation $this) {
        return $this.toString();
    }

    default public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s for %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Misc$.MODULE$.getNameFromClass(this), this.rd().diagnosticDebugName()}));
    }

    public boolean test(UState var1);

    public void continuation(UState var1);

    public static void doTask$(SuspendableOperation $this, UState ustate) {
        $this.doTask(ustate);
    }

    @Override
    default public void doTask(UState ustate) {
        if (this.isBlocked()) {
            this.setUnblocked();
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("retrying {}", (Object)this);
            }
        }
        while (!this.isDone() && !this.isBlocked()) {
            try {
                boolean tst = this.test(ustate);
                if (tst) {
                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("test() of {} {} passed", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, BoxesRunTime.boxToBoolean((boolean)tst)}), Object.class));
                    }
                    this.setDone();
                } else {
                    Object object;
                    Object object2;
                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("test() of {} {} failed", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, BoxesRunTime.boxToBoolean((boolean)tst)}), Object.class));
                    }
                    if (Maybe$.MODULE$.isDefined$extension(object2 = ustate.currentInfosetNodeMaybe())) {
                        Object object3 = ustate.currentInfosetNodeMaybe();
                        object = (DINode)Maybe$.MODULE$.get$extension(object3);
                    } else {
                        object = "No Node";
                    }
                    String nodeOpt = object;
                    this.block(nodeOpt, ustate.getDataOutputStream(), 0L, this);
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof RetryableException) {
                    Object object;
                    Object object4;
                    Throwable e = (Throwable)((Object)((RetryableException)((Object)throwable2)));
                    Logger LoggerImpl_this = Logger$.MODULE$.log();
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("test() of {} threw {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this, e}), Object.class));
                    }
                    if (Maybe$.MODULE$.isDefined$extension(object4 = ustate.currentInfosetNodeMaybe())) {
                        Object object5 = ustate.currentInfosetNodeMaybe();
                        object = (DINode)Maybe$.MODULE$.get$extension(object5);
                    } else {
                        object = "No Node";
                    }
                    String nodeOpt = object;
                    this.block(nodeOpt, ustate.getDataOutputStream(), 0L, e);
                }
                throw throwable;
            }
            if (this.isDone() || this.isBlocked()) continue;
            throw Assert$.MODULE$.abort("Invariant broken: SuspendableOperation.this.isBlocked");
        }
        if (this.isDone()) {
            Logger LoggerImpl_this = Logger$.MODULE$.log();
            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                LoggerImpl_this.underlying().debug("continuation() of {}", (Object)this);
            }
            this.continuation(ustate);
            Logger LoggerImpl_this2 = Logger$.MODULE$.log();
            if (LoggerImpl_this2.underlying().isDebugEnabled()) {
                LoggerImpl_this2.underlying().debug("continuation() of {} done!", (Object)this);
                return;
            }
            return;
        }
    }
}

