/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.infoset;

import java.io.Serializable;
import org.apache.daffodil.api.infoset.InfosetArray;
import org.apache.daffodil.api.metadata.ElementMetadata;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.runtime1.infoset.DIComplex;
import org.apache.daffodil.runtime1.infoset.DIElement;
import org.apache.daffodil.runtime1.infoset.DINode;
import org.apache.daffodil.runtime1.infoset.InfosetArrayIndexOutOfBoundsException;
import org.apache.daffodil.runtime1.infoset.InfosetArrayNotFinalException;
import org.apache.daffodil.runtime1.infoset.InfosetFatalArrayIndexOutOfBoundsException;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class DIArray
implements DINode,
InfosetArray {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DIArray.class.getDeclaredField("nfe$lzy1"));
    private boolean wouldHaveBeenFreed;
    private boolean org$apache$daffodil$runtime1$infoset$DINode$$_isFinal;
    private final ElementRuntimeData erd;
    private final DIComplex parent;
    private volatile Object nfe$lzy1;
    private final ArrayBuffer _contents;

    public DIArray(ElementRuntimeData erd, DIComplex parent, int initialSize) {
        this.erd = erd;
        this.parent = parent;
        DINode.$init$(this);
        this._contents = new ArrayBuffer(initialSize);
    }

    @Override
    public boolean wouldHaveBeenFreed() {
        return this.wouldHaveBeenFreed;
    }

    @Override
    public boolean org$apache$daffodil$runtime1$infoset$DINode$$_isFinal() {
        return this.org$apache$daffodil$runtime1$infoset$DINode$$_isFinal;
    }

    @Override
    public void wouldHaveBeenFreed_$eq(boolean x$1) {
        this.wouldHaveBeenFreed = x$1;
    }

    @Override
    public void org$apache$daffodil$runtime1$infoset$DINode$$_isFinal_$eq(boolean x$1) {
        this.org$apache$daffodil$runtime1$infoset$DINode$$_isFinal = x$1;
    }

    @Override
    public ElementRuntimeData erd() {
        return this.erd;
    }

    public DIComplex parent() {
        return this.parent;
    }

    @Override
    public ElementMetadata metadata() {
        return this.erd();
    }

    private InfosetArrayNotFinalException nfe() {
        Object object = this.nfe$lzy1;
        if (object instanceof InfosetArrayNotFinalException) {
            return (InfosetArrayNotFinalException)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (InfosetArrayNotFinalException)this.nfe$lzyINIT1();
    }

    private Object nfe$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.nfe$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    InfosetArrayNotFinalException infosetArrayNotFinalException = null;
                    try {
                        infosetArrayNotFinalException = new InfosetArrayNotFinalException(this);
                        object2 = infosetArrayNotFinalException == null ? LazyVals.NullValue$.MODULE$ : infosetArrayNotFinalException;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.nfe$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return infosetArrayNotFinalException;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void requireFinal() {
        if (!this.isFinal()) {
            throw this.nfe();
        }
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isComplex() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public DINode diParent() {
        return this.parent();
    }

    @Override
    public boolean isHidden() {
        return ((DIElement)this._contents().apply(0)).isHidden();
    }

    @Override
    public int infosetWalkerBlockCount() {
        return this.parent().infosetWalkerBlockCount() + (this._contents().apply(0) == null ? 0 : ((DIElement)this._contents().apply(0)).infosetWalkerBlockCount());
    }

    public String toString() {
        return "DIArray(" + this.namedQName() + "," + this._contents() + ")";
    }

    @Override
    public NamedQName namedQName() {
        return this.erd().namedQName();
    }

    public final ArrayBuffer<DIElement> _contents() {
        return this._contents;
    }

    @Override
    public int indexOf(DINode item) {
        return this._contents().indexOf((Object)item);
    }

    public void reduceToSize(int n) {
        this._contents().dropRightInPlace(this._contents().length() - n);
    }

    @Override
    public int numChildren() {
        return this._contents().length();
    }

    @Override
    public DINode child(int index) {
        return (DINode)this._contents().apply(index);
    }

    @Override
    public Option<DINode> find(Function1<DINode, Object> func) {
        return this._contents().find(func);
    }

    @Override
    public Object maybeLastChild() {
        int len = this._contents().length();
        if (len > 0) {
            return Maybe$.MODULE$.apply(this._contents().apply(len - 1));
        }
        return Maybe$.MODULE$.Nope();
    }

    public DIElement apply(long occursIndex1b) {
        if (occursIndex1b < 1L) {
            throw this.erd().toss(new InfosetFatalArrayIndexOutOfBoundsException(this, occursIndex1b, this.length()));
        }
        if (occursIndex1b > this.length()) {
            throw this.erd().toss(new InfosetArrayIndexOutOfBoundsException(this, occursIndex1b, this.length()));
        }
        return (DIElement)this._contents().apply((int)occursIndex1b - 1);
    }

    public void append(DIElement ie) {
        if (this.isFinal()) {
            throw Assert$.MODULE$.abort("Invariant broken: DIArray.this.isFinal.unary_!");
        }
        this._contents().$plus$eq((Object)ie);
        ie.setArray(this);
    }

    public void concat(DIArray array) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), array.numChildren()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            DINode in = array.child(i);
            DIElement ie = (DIElement)in;
            ie.setArray(this);
            this.append(ie);
        });
    }

    public final long length() {
        return Int$.MODULE$.int2long(this._contents().length());
    }

    @Override
    public final boolean isDefaulted() {
        return this._contents().forall((Function1 & Serializable)_$5 -> _$5.isDefaulted());
    }

    @Override
    public final void freeChildIfNoLongerNeeded(int index, boolean doFree) {
        DIElement node = (DIElement)this._contents().apply(index);
        if (!node.erd().dpathElementCompileInfo().isReferencedByExpressions()) {
            if (doFree) {
                this._contents().update(index, null);
                return;
            }
            node.wouldHaveBeenFreed_$eq(true);
            return;
        }
    }
}

