/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.FloatConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FloatConverterTest
extends AbstractNumberConverterTest<Float> {
    private Converter<Float> converter;

    @Override
    protected Class<Float> getExpectedType() {
        return Float.class;
    }

    protected FloatConverter makeConverter() {
        return new FloatConverter();
    }

    protected FloatConverter makeConverter(Float defaultValue) {
        return new FloatConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = Float.valueOf("-12");
        this.numbers[1] = Float.valueOf("13");
        this.numbers[2] = Float.valueOf("-22");
        this.numbers[3] = Float.valueOf("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testInvalidAmount() {
        FloatConverter converter = this.makeConverter();
        Class<Float> clazz = Float.class;
        Double max = 3.4028234663852886E38;
        Double tooBig = Double.MAX_VALUE;
        Assertions.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)converter.convert(clazz, (Object)max), (String)"Maximum");
        Assertions.assertThrows(ConversionException.class, () -> FloatConverterTest.lambda$testInvalidAmount$0((Converter)converter, clazz, tooBig), (String)"More than maximum, expected ConversionException");
    }

    @Test
    public void testSimpleConversion() {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Float.MIN_VALUE), "-17.2", "-1.1", "0.0", "1.1", "17.2", String.valueOf(Float.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        Float[] expected = new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(-17.2f), Float.valueOf(-1.1f), Float.valueOf(0.0f), Float.valueOf(1.1f), Float.valueOf(17.2f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(7.0f), Float.valueOf(8.0f), Float.valueOf(9.0f), Float.valueOf(10.0f), Float.valueOf(11.1f), Float.valueOf(12.2f)};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.class, input[i])).floatValue(), (double)1.0E-5, (String)(message[i] + " to Float"));
            Assertions.assertEquals((double)expected[i].floatValue(), (double)((Float)this.converter.convert(Float.TYPE, input[i])).floatValue(), (double)1.0E-5, (String)(message[i] + " to float"));
            Assertions.assertEquals((double)expected[i].floatValue(), (double)((Float)this.converter.convert((Class)null, input[i])).floatValue(), (double)1.0E-5, (String)(message[i] + " to null type"));
        }
    }

    private static /* synthetic */ void lambda$testInvalidAmount$0(Converter converter, Class clazz, Double tooBig) throws Throwable {
        converter.convert(clazz, (Object)tooBig);
    }
}

