/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.spring.redis.it;

import java.util.Map;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import org.eclipse.microprofile.config.ConfigProvider;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;

public class SpringRedisTestResource implements QuarkusTestResourceLifecycleManager {
    private static final String REDIS_IMAGE_NAME = ConfigProvider.getConfig().getValue("redis.container.image", String.class);
    private static final int REDIS_PORT = 6379;

    private GenericContainer<?> container;

    @Override
    public Map<String, String> start() {
        container = new GenericContainer<>(REDIS_IMAGE_NAME)
                .withExposedPorts(REDIS_PORT)
                .withClasspathResourceMapping("redis.conf", "/usr/local/etc/redis", BindMode.READ_ONLY)
                .waitingFor(Wait.forListeningPort());

        container.start();

        return Map.of(
                "redis.host", container.getHost(),
                "redis.port", container.getMappedPort(REDIS_PORT).toString());
    }

    @Override
    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        } catch (Exception e) {
            // ignored
        }
    }
}
