/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.binding.encoding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.encoder.BaseMessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSAML2MessageEncoder
extends BaseMessageEncoder
implements SAMLMessageEncoder {
    private final Logger log = LoggerFactory.getLogger(BaseSAML2MessageEncoder.class);
    private List<String> allowedURLSchemes;

    public BaseSAML2MessageEncoder() {
        this.setAllowedURLSchemes(new String[]{"http", "https"});
    }

    public List<String> getAllowedURLSchemes() {
        return this.allowedURLSchemes;
    }

    public void setAllowedURLSchemes(String[] schemes) {
        if (schemes == null || schemes.length == 0) {
            this.allowedURLSchemes = Collections.emptyList();
        } else {
            ArrayList<String> temp = new ArrayList<String>();
            for (String scheme : schemes) {
                temp.add(scheme);
            }
            this.allowedURLSchemes = Collections.unmodifiableList(temp);
        }
    }

    protected URLBuilder getEndpointURL(SAMLMessageContext messageContext) throws MessageEncodingException {
        URLBuilder urlBuilder;
        Endpoint endpoint = messageContext.getPeerEntityEndpoint();
        if (endpoint == null) {
            throw new MessageEncodingException("Endpoint for relying party was null.");
        }
        if (messageContext.getOutboundMessage() instanceof StatusResponseType && !DatatypeHelper.isEmpty((String)endpoint.getResponseLocation())) {
            urlBuilder = new URLBuilder(endpoint.getResponseLocation());
        } else {
            if (DatatypeHelper.isEmpty((String)endpoint.getLocation())) {
                throw new MessageEncodingException("Relying party endpoint location was null or empty.");
            }
            urlBuilder = new URLBuilder(endpoint.getLocation());
        }
        if (!this.getAllowedURLSchemes().contains(urlBuilder.getScheme())) {
            throw new MessageEncodingException("Relying party endpoint used the untrusted URL scheme " + urlBuilder.getScheme());
        }
        return urlBuilder;
    }

    protected boolean checkRelayState(String relayState) {
        if (!DatatypeHelper.isEmpty((String)relayState)) {
            if (relayState.getBytes().length > 80) {
                this.log.warn("Relay state exceeds 80 bytes, some application may not support this.");
            }
            return true;
        }
        return false;
    }

    protected void setResponseDestination(SAMLObject outboundMessage, String endpointURL) {
        if (outboundMessage instanceof StatusResponseType) {
            ((StatusResponseType)outboundMessage).setDestination(endpointURL);
        }
    }

    protected void signMessage(SAMLMessageContext messageContext) throws MessageEncodingException {
        Object outboundSAML = messageContext.getOutboundSAMLMessage();
        Credential signingCredential = messageContext.getOuboundSAMLMessageSigningCredential();
        if (outboundSAML instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)outboundSAML;
            XMLObjectBuilder signatureBuilder = Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential(signingCredential);
            try {
                SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
            }
            catch (SecurityException e) {
                throw new MessageEncodingException("Error preparing signature for signing", (Exception)((Object)e));
            }
            signableMessage.setSignature(signature);
            try {
                Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new MessageEncodingException("No marshaller registered for " + signableMessage.getElementQName() + ", unable to marshall in preperation for signing");
                }
                marshaller.marshall((XMLObject)signableMessage);
                Signer.signObject((Signature)signature);
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall protocol message in preparation for signing", (Throwable)e);
                throw new MessageEncodingException("Unable to marshall protocol message in preparation for signing", (Exception)((Object)e));
            }
            catch (SignatureException e) {
                this.log.error("Unable to sign protocol message", (Throwable)e);
                throw new MessageEncodingException("Unable to sign protocol message", (Exception)((Object)e));
            }
        }
    }
}

