/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl.ssl;

import org.apache.qpid.proton.engine.impl.HandshakeSniffingTransportWrapper;
import org.apache.qpid.proton.engine.impl.TransportWrapper;
import org.apache.qpid.proton.engine.impl.ssl.SslTransportWrapper;

public class SslHandshakeSniffingTransportWrapper
extends HandshakeSniffingTransportWrapper<SslTransportWrapper, TransportWrapper>
implements SslTransportWrapper {
    SslHandshakeSniffingTransportWrapper(SslTransportWrapper ssl, TransportWrapper plain) {
        super(ssl, plain);
    }

    @Override
    public String getCipherName() {
        if (this.isSecureWrapperSelected()) {
            return ((SslTransportWrapper)this._wrapper1).getCipherName();
        }
        return null;
    }

    @Override
    public String getProtocolName() {
        if (this.isSecureWrapperSelected()) {
            return ((SslTransportWrapper)this._wrapper1).getProtocolName();
        }
        return null;
    }

    private boolean isSecureWrapperSelected() {
        return this._selectedTransportWrapper == this._wrapper1;
    }

    @Override
    protected int bufferSize() {
        return 5;
    }

    @Override
    protected void makeDetermination(byte[] bytesInput) {
        boolean isSecure = this.checkForSslHandshake(bytesInput);
        this._selectedTransportWrapper = isSecure ? this._wrapper1 : this._wrapper2;
    }

    private boolean checkForSslHandshake(byte[] buf) {
        if (buf.length >= this.bufferSize()) {
            boolean isSSL2Handshake = buf[2] == 1 && (buf[3] == 3 && buf[4] <= 3 || buf[3] == 2 && buf[4] == 0);
            boolean isSSL3Handshake = buf[0] == 22 && buf[1] == 3 && buf[2] <= 3;
            return isSSL2Handshake || isSSL3Handshake;
        }
        throw new IllegalArgumentException("Too few bytes (" + buf.length + ") to make SSL/plain  determination.");
    }
}

