/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import com.ten60.netkernel.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class DynamicURLClassLoader
extends ClassLoader {
    private ClassLoader mParent;
    private List mURLs;
    private static byte[] mBuffer1 = new byte[40000];
    private static Thread mBuffer1User = null;
    private static int mBuffer1Count = 0;
    private static byte[] mBuffer2 = new byte[40000];
    private static Thread mBuffer2User = null;
    private static int mBuffer2Count = 0;
    private static Integer mBufferSync = new Integer(0);

    public DynamicURLClassLoader(ClassLoader aParent, List aURLs) {
        this.mParent = aParent;
        this.mURLs = this.parseURLs(aURLs);
    }

    public void cleanup() {
        this.mURLs = null;
        this.mParent = null;
    }

    private List parseURLs(List aURLs) {
        ArrayList<ClassPathElement> result = new ArrayList<ClassPathElement>(aURLs.size());
        Iterator i = aURLs.iterator();
        while (i.hasNext()) {
            String url = (String)i.next();
            String message = null;
            try {
                File f;
                if (url.startsWith("file:") && url.endsWith("/")) {
                    URI uri = URI.create(url);
                    f = new File(uri);
                    if (f.exists()) {
                        ClassPathElement cpe = new ClassPathElement(f, url);
                        result.add(cpe);
                    } else {
                        message = "file doesn't exist";
                    }
                } else if (url.startsWith("jar:file:") && url.endsWith("!/")) {
                    String fileURI = url.substring(4, url.length() - 2);
                    f = new File(URI.create(fileURI));
                    JarFile jf = new JarFile(f);
                    ClassPathElement cpe = new ClassPathElement(jf, url);
                    result.add(cpe);
                } else {
                    message = "this URL isn't valid";
                }
            }
            catch (Exception e) {
                message = "Unhandled exception " + e.getClass().getName() + ": " + e.getMessage();
            }
            if (message == null) continue;
            System.out.println("DynamicURLClassLoader failed to parse " + url + ": " + message);
        }
        return result;
    }

    public Class loadClass(String aName, boolean aResolve) throws ClassNotFoundException {
        Class c = this.loadClass(aName);
        if (aResolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public Class loadClass(String aName) throws ClassNotFoundException {
        Class result = this.innerLocalLoadClass(aName);
        if (result == null) {
            throw new ClassNotFoundException(aName);
        }
        return result;
    }

    protected synchronized Class innerLocalLoadClass(String aName) {
        Class result = this.findLoadedClass(aName);
        if (result == null) {
            result = this.innerLoadClass(aName);
        }
        return result;
    }

    public URL getResource(String aName) {
        try {
            boolean found = false;
            Iterator i = this.mURLs.iterator();
            while (i.hasNext()) {
                ClassPathElement cpe = (ClassPathElement)i.next();
                if (cpe.mJarFile != null) {
                    JarEntry je = cpe.mJarFile.getJarEntry(aName);
                    found = je != null;
                } else {
                    File f = new File(cpe.mDirectory, aName);
                    found = f.exists();
                }
                if (!found) continue;
                StringBuffer sb = new StringBuffer(aName.length() + cpe.mBaseURL.length());
                sb.append(cpe.mBaseURL);
                Utils.appendUnreservedURIChar(sb, aName);
                return new URL(sb.toString());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBuffer(int aLength) {
        byte[] result;
        Integer n = mBufferSync;
        synchronized (n) {
            Thread current = Thread.currentThread();
            if (mBuffer1User != null && mBuffer1User != current) {
                if (mBuffer2User != null && mBuffer2User != current) {
                    result = new byte[aLength];
                } else {
                    if (mBuffer2.length < aLength) {
                        mBuffer2 = new byte[aLength];
                    }
                    result = mBuffer2;
                    mBuffer2User = current;
                    ++mBuffer2Count;
                }
            } else {
                if (mBuffer1.length < aLength) {
                    mBuffer1 = new byte[aLength];
                }
                result = mBuffer1;
                mBuffer1User = current;
                ++mBuffer1Count;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseBuffer(byte[] aBuffer) {
        Integer n = mBufferSync;
        synchronized (n) {
            if (aBuffer == mBuffer1) {
                if (--mBuffer1Count == 0) {
                    mBuffer1User = null;
                }
            } else if (aBuffer == mBuffer2 && --mBuffer2Count == 0) {
                mBuffer2User = null;
            }
        }
    }

    private Class innerLoadClass(String aName) {
        StringBuffer sb = new StringBuffer(aName.length() + 6);
        sb.append(aName.replace('.', '/'));
        sb.append(".class");
        String resource = sb.toString();
        Class result = null;
        try {
            Iterator i = this.mURLs.iterator();
            while (i.hasNext()) {
                ClassPathElement cpe = (ClassPathElement)i.next();
                if (cpe.mJarFile != null) {
                    JarEntry je = cpe.mJarFile.getJarEntry(resource);
                    if (je == null) continue;
                    result = this.createClassFromInputStream(aName, cpe.mJarFile.getInputStream(je), (int)je.getSize());
                } else {
                    File f = new File(cpe.mDirectory, resource);
                    if (!f.exists()) continue;
                    result = this.createClassFromInputStream(aName, new FileInputStream(f), (int)f.length());
                }
                break;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class createClassFromInputStream(String aName, InputStream aStream, int aLength) throws IOException {
        byte[] buffer = DynamicURLClassLoader.getBuffer(aLength);
        try {
            Class<?> result;
            int r;
            for (int j = 0; j < aLength; j += r) {
                r = aStream.read(buffer, j, aLength - j);
            }
            aStream.close();
            Class<?> clazz = result = this.defineClass(aName, buffer, 0, aLength);
            return clazz;
        }
        finally {
            DynamicURLClassLoader.releaseBuffer(buffer);
        }
    }

    private class ClassPathElement {
        public JarFile mJarFile;
        public File mDirectory;
        public String mBaseURL;

        public ClassPathElement(JarFile aJar, String aBaseURL) {
            this.mJarFile = aJar;
            this.mBaseURL = aBaseURL;
        }

        public ClassPathElement(File aDir, String aBaseURL) {
            this.mDirectory = aDir;
            this.mBaseURL = aBaseURL;
        }
    }
}

