/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AsynchLock {
    private Map mKeyToReferences;
    private int mContentionCount;
    private static Object sNoPendingLocks = Boolean.FALSE;

    public AsynchLock(int aKeyCount, int aContentionCount) {
        this.mKeyToReferences = new HashMap(aKeyCount);
        this.mContentionCount = aContentionCount;
    }

    public boolean lock(Object aKey, Object aReference) {
        boolean result;
        Object lookup = this.mKeyToReferences.get(aKey);
        if (lookup == null) {
            result = true;
            this.mKeyToReferences.put(aKey, sNoPendingLocks);
        } else {
            ArrayList<Object> pendingList;
            result = false;
            if (lookup == sNoPendingLocks) {
                pendingList = new ArrayList<Object>(this.mContentionCount);
                this.mKeyToReferences.put(aKey, pendingList);
            } else {
                pendingList = (ArrayList<Object>)lookup;
            }
            pendingList.add(aReference);
        }
        return result;
    }

    public Object unlock(Object aKey) {
        Object result = null;
        Object lookup = this.mKeyToReferences.remove(aKey);
        if (lookup instanceof List) {
            List pendingList = (List)lookup;
            result = pendingList.remove(0);
            if (pendingList.isEmpty()) {
                this.mKeyToReferences.put(aKey, sNoPendingLocks);
            } else {
                this.mKeyToReferences.put(aKey, pendingList);
            }
        }
        return result;
    }

    public Iterator getPendingReferences() {
        return new LockIterator();
    }

    private class LockIterator
    implements Iterator {
        private Iterator mMapIterator;
        private Iterator mListIterator;
        private Object mNext;

        public LockIterator() {
            this.mMapIterator = AsynchLock.this.mKeyToReferences.values().iterator();
            this.findNext();
        }

        public boolean hasNext() {
            return this.mNext != null;
        }

        public Object next() {
            Object result = this.mNext;
            this.findNext();
            return result;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            while (this.mListIterator == null || !this.mListIterator.hasNext()) {
                if (this.mMapIterator.hasNext()) {
                    Object o = this.mMapIterator.next();
                    if (o != sNoPendingLocks) {
                        List list = (List)o;
                        this.mListIterator = list.iterator();
                        continue;
                    }
                    this.mListIterator = null;
                    continue;
                }
                this.mListIterator = null;
                break;
            }
            this.mNext = this.mListIterator != null ? this.mListIterator.next() : null;
        }
    }
}

