/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.transport;

import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Config;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.scheduler.Scheduler;
import com.ten60.netkernel.transport.ITransport;
import com.ten60.netkernel.transport.RequestBlocker;
import com.ten60.netkernel.transport.Throttle;
import com.ten60.netkernel.transport.ThrottleOverloadException;
import com.ten60.netkernel.transport.TransportDeploymentRecord;
import com.ten60.netkernel.transport.TransportInitiatedSession;
import com.ten60.netkernel.urii.IURMeta;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;
import com.ten60.netkernel.urrequest.IURRequestor;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urrequest.URResult;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.PairList;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TransportManager
extends ComponentImpl
implements IURRequestor {
    public static final URIdentifier URI = new URIdentifier("netkernel:tm");
    public static final String INTERNAL_TRANSPORT = "InternalTransport";
    private List mTransports = new ArrayList();
    private Scheduler mUS;
    private Map mResultTable = Collections.synchronizedMap(new IdentityHashMap());
    private Throttle mThrottle = new Throttle();
    private RequestBlocker mBlocker = new RequestBlocker();
    private boolean mAcceptingRequests = true;
    private Container mContainer;
    public static final String EX_SERVICE_UNAVAILABLE = "Service Unavailable";
    private int mStatBufferSize;
    private int mStatFreqDivider;
    private DateFormat mDateFormat;
    private int mFreqDivider;
    private int mBufferIndex;
    private int mWorkPeriod;
    private long[] mTimeStamps;
    private float[] mThrottleStats;
    private int mQueueSize;
    private int mRejectedRequests;
    private int mConcurrentReq;
    private long mTotalRequests;

    public TransportManager() {
        super(URI);
    }

    public void start(Container aContainer) throws NetKernelException {
        this.mContainer = aContainer;
        this.mUS = (Scheduler)aContainer.getComponent(Scheduler.URI);
        Config config = (Config)aContainer.getComponent(Config.URI);
        int throttle = config.getReadable().getInt("system/throttle", 5);
        this.mThrottle.setMaxCount(throttle);
        int throttleQueue = config.getReadable().getInt("system/throttleQueue", 10);
        this.mThrottle.setMaxQueue(throttleQueue);
        ModuleManager mm = (ModuleManager)this.mContainer.getComponent(ModuleManager.URI);
        PairList transports = mm.getTransports();
        this.holdRequests();
        this.refresh(transports);
    }

    public void refresh(PairList aTransports) {
        ModuleDefinition md;
        String transportClassString;
        Config config = (Config)this.mContainer.getComponent(Config.URI);
        XMLReadable cr = config.getReadable();
        this.mStatBufferSize = cr.getInt("system/statistics/historySize", 60);
        this.mStatFreqDivider = cr.getInt("system/statistics/frequencyDivisor", 10);
        int houseKeepingPeriod = cr.getInt("system/houseKeepingPeriod", 500);
        this.mDateFormat = new SimpleDateFormat(cr.getText("system/statistics/timestampFormat").trim());
        this.mTimeStamps = new long[this.mStatBufferSize * 2];
        this.mThrottleStats = new float[this.mStatBufferSize * 3];
        this.mWorkPeriod = houseKeepingPeriod * this.mStatFreqDivider / 1000;
        if (this.mWorkPeriod == 0) {
            this.mWorkPeriod = 1;
        }
        NetKernelException exception = null;
        this.mBlocker.block();
        ArrayList<ITransport> stoppedTransports = new ArrayList<ITransport>();
        Iterator i = this.mTransports.iterator();
        while (i.hasNext()) {
            TransportDeploymentRecord tdr = (TransportDeploymentRecord)i.next();
            transportClassString = tdr.getTransport().getClass().getName();
            if (aTransports.contains(transportClassString, md = tdr.getModule())) continue;
            ITransport transport = tdr.getTransport();
            stoppedTransports.add(transport);
            this.mBlocker.interrupt(transport);
        }
        this.mBlocker.releaseInterrupted();
        i = stoppedTransports.iterator();
        while (i.hasNext()) {
            ITransport transport = (ITransport)i.next();
            try {
                transport.stop();
                SysLogger.log1(6, this, "  Uninstalled transport [%1]", transport.getDescription());
            }
            catch (NetKernelException e) {
                if (exception == null) {
                    exception = new NetKernelException("transport refresh had problems");
                }
                exception.addCause(e);
            }
        }
        ArrayList<TransportDeploymentRecord> newTransports = new ArrayList<TransportDeploymentRecord>();
        for (int i2 = 0; i2 < aTransports.size(); ++i2) {
            transportClassString = (String)aTransports.getValue1(i2);
            md = (ModuleDefinition)aTransports.getValue2(i2);
            if (transportClassString.equals(INTERNAL_TRANSPORT)) continue;
            boolean started = false;
            Iterator j = this.mTransports.iterator();
            while (j.hasNext()) {
                TransportDeploymentRecord tdr = (TransportDeploymentRecord)j.next();
                if (!tdr.getModule().equals(md) || !tdr.getTransportClass().equals(transportClassString)) continue;
                tdr = new TransportDeploymentRecord(tdr.getTransport(), md, this.mStatBufferSize);
                tdr.getTransport().setContext(md);
                newTransports.add(tdr);
                started = true;
                break;
            }
            if (started) continue;
            try {
                ClassLoader cl = md.getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                ITransport transport = this.createTransport(transportClassString, cl);
                transport.start(this.mContainer, md);
                TransportDeploymentRecord tdr = new TransportDeploymentRecord(transport, md, this.mStatBufferSize);
                newTransports.add(tdr);
                SysLogger.log1(6, this, "  Installed transport [%1]", transport.getDescription());
                continue;
            }
            catch (NetKernelException e) {
                if (exception == null) {
                    exception = new NetKernelException("transport refresh had problems");
                }
                exception.addCause(e);
            }
        }
        this.mTransports = newTransports;
        if (exception != null) {
            SysLogger.log(3, this, exception.toString());
        }
    }

    public void holdRequests() {
        this.mBlocker.block();
    }

    public void rejectRequests() {
        this.mAcceptingRequests = false;
    }

    public void acceptRequests() {
        this.mAcceptingRequests = true;
        this.mBlocker.release();
        this.mBlocker.clear();
    }

    public void stop() throws NetKernelException {
        this.rejectRequests();
        this.refresh(new PairList(1));
        this.mContainer = null;
        this.mUS = null;
    }

    private ITransport createTransport(String aTransportClassString, ClassLoader aClassLoader) throws NetKernelException {
        try {
            Class<?> c = aClassLoader.loadClass(aTransportClassString);
            ITransport result = (ITransport)c.newInstance();
            return result;
        }
        catch (Exception e) {
            NetKernelException e2 = new NetKernelException("Failed to create transport class", null, aTransportClassString);
            e2.addCause(e);
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IURRepresentation handleRequest(URRequest aRequest, ITransport aTransport) {
        try {
            IURRepresentation result;
            this.doBlockerAndThrottle(aTransport);
            aRequest.setSession(new TransportInitiatedSession());
            try {
                result = this.innerHandleRequest(aRequest, aTransport);
            }
            finally {
                this.mThrottle.notifyOfReturn();
            }
            this.cleanup(result, aTransport);
            return result;
        }
        catch (InterruptedException e) {
            NetKernelException e2 = new NetKernelException(EX_SERVICE_UNAVAILABLE, "Request Interrupted", null);
            return NetKernelExceptionAspect.create(e2);
        }
        catch (ThrottleOverloadException e) {
            Object e2 = this;
            synchronized (e2) {
                ++this.mRejectedRequests;
            }
            SysLogger.log1(2, this, "Request %1 rejected due to throttle overload", aRequest.getURI().toString());
            e2 = new NetKernelException(EX_SERVICE_UNAVAILABLE, "Max Concurrent Requests Exceeded", null);
            return NetKernelExceptionAspect.create((NetKernelException)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IURRepresentation innerHandleRequest(URRequest aRequest, ITransport aTransport) throws InterruptedException {
        URResult result;
        aRequest.setRequestor(this);
        this.mUS.requestAsync(aRequest);
        URRequest uRRequest = aRequest;
        synchronized (uRRequest) {
            do {
                if ((result = (URResult)this.mResultTable.remove(aRequest)) != null) continue;
                aRequest.wait();
            } while (result == null);
        }
        return result.getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetKernelException handleAsyncRequest(URRequest aRequest, ITransport aTransport) {
        NetKernelException failureResult = null;
        try {
            this.doBlockerAndThrottle(aTransport);
            aRequest.setSession(new TransportInitiatedSession());
            RequestorIntermediary intermediary = new RequestorIntermediary(aRequest.getRequestor(), aTransport);
            aRequest.setRequestor(intermediary);
            this.mUS.requestAsync(aRequest);
        }
        catch (InterruptedException e) {
            failureResult = new NetKernelException(EX_SERVICE_UNAVAILABLE, "Request Interrupted", null);
        }
        catch (ThrottleOverloadException e) {
            TransportManager transportManager = this;
            synchronized (transportManager) {
                ++this.mRejectedRequests;
            }
            SysLogger.log1(2, this, "Request %1 rejected due to throttle overload", aRequest.getURI().toString());
            failureResult = new NetKernelException(EX_SERVICE_UNAVAILABLE, "Max Concurrent Requests Exceeded", null);
        }
        return failureResult;
    }

    private void doBlockerAndThrottle(ITransport aTransport) throws InterruptedException, ThrottleOverloadException {
        this.mBlocker.check(aTransport);
        if (!this.mAcceptingRequests) {
            throw new InterruptedException();
        }
        this.mThrottle.throttle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(IURRepresentation aResult, ITransport aTransport) {
        for (int i = this.mTransports.size() - 1; i >= 0; --i) {
            TransportDeploymentRecord tdr = (TransportDeploymentRecord)this.mTransports.get(i);
            if (tdr.getTransport() != aTransport) continue;
            IURMeta meta = aResult.getMeta();
            tdr.accumulateWork(meta.getCreationCost() + meta.getUsageCost(), this.mBufferIndex);
            break;
        }
        TransportManager transportManager = this;
        synchronized (transportManager) {
            ++this.mTotalRequests;
        }
    }

    public void receiveAsyncResult(URResult aResult) {
        this.returnResult(aResult);
    }

    public void receiveAsyncException(URResult aResult) {
        this.returnResult(aResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnResult(URResult aResult) {
        URRequest request = aResult.getRequest();
        this.mResultTable.put(request, aResult);
        URRequest uRRequest = request;
        synchronized (uRRequest) {
            request.notify();
        }
    }

    public void join() {
        int count = 2;
        while (count > 0) {
            count = this.mThrottle.isBusy() ? 2 : --count;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPeriodicHouseKeeping() {
        this.mQueueSize += this.mThrottle.getQueueSize();
        this.mConcurrentReq += this.mThrottle.getConcurrentCount();
        this.mFreqDivider = (this.mFreqDivider + 1) % this.mStatFreqDivider;
        if (this.mFreqDivider == 0) {
            long now = System.currentTimeMillis();
            int p = this.mBufferIndex * 2;
            this.mTimeStamps[p] = now;
            TransportManager transportManager = this;
            synchronized (transportManager) {
                this.mTimeStamps[p + 1] = this.mTotalRequests;
            }
            for (int i = this.mTransports.size() - 1; i >= 0; --i) {
                TransportDeploymentRecord tdr = (TransportDeploymentRecord)this.mTransports.get(i);
                tdr.accumulateWork(0, this.mBufferIndex);
            }
            float factor = 1.0f / (float)this.mStatFreqDivider;
            float concurrent = (float)this.mConcurrentReq * factor;
            float queue = (float)this.mQueueSize * factor;
            float reject = (float)this.mRejectedRequests / (float)this.mWorkPeriod;
            this.mQueueSize = 0;
            this.mConcurrentReq = 0;
            this.mRejectedRequests = 0;
            p = this.mBufferIndex * 3;
            this.mThrottleStats[p] = concurrent;
            this.mThrottleStats[p + 1] = queue;
            this.mThrottleStats[p + 2] = reject;
            this.mBufferIndex = (this.mBufferIndex + 1) % this.mStatBufferSize;
        }
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<transports>");
        Iterator j = this.mTransports.iterator();
        while (j.hasNext()) {
            TransportDeploymentRecord tdr = (TransportDeploymentRecord)j.next();
            osw.write("<transport>");
            TransportManager.write(osw, "module", XMLUtils.escape(tdr.getModule().getURI().toString()));
            TransportManager.write(osw, "version", XMLUtils.escape(tdr.getModule().getVersion().toString(3)));
            TransportManager.write(osw, "class", XMLUtils.escape(tdr.getTransportClass()));
            TransportManager.write(osw, "desc", XMLUtils.escape(tdr.getTransport().getDescription()));
            osw.write("<work>");
            long[] stats = tdr.getWork();
            int index = this.mBufferIndex;
            for (int i = 0; i < this.mStatBufferSize; ++i) {
                if (++index >= this.mStatBufferSize) {
                    index = 0;
                }
                osw.write("<stat>");
                TransportManager.write(osw, "work", Long.toString(stats[index] / (long)this.mWorkPeriod));
                osw.write("</stat>");
            }
            osw.write("</work>");
            osw.write("</transport>");
        }
        osw.write("<throttle>");
        int index = this.mBufferIndex;
        for (int i = 0; i < this.mStatBufferSize; ++i) {
            osw.write("<stat>");
            int p = index * 3;
            TransportManager.write(osw, "concurrency", Float.toString(this.mThrottleStats[p]));
            TransportManager.write(osw, "queue", Float.toString(this.mThrottleStats[p + 1]));
            TransportManager.write(osw, "rejected", Float.toString(this.mThrottleStats[p + 2]));
            p = index * 2;
            TransportManager.write(osw, "total", Long.toString(this.mTimeStamps[p + 1]));
            long time = this.mTimeStamps[p];
            if (time == 0L) {
                TransportManager.write(osw, "time", "-");
            } else {
                TransportManager.write(osw, "time", this.mDateFormat.format(new Date(time)));
            }
            osw.write("</stat>");
            if (++index < this.mStatBufferSize) continue;
            index = 0;
        }
        osw.write("</throttle>");
        osw.write("</transports>");
        osw.flush();
    }

    private static void write(Writer osw, String aName, String aValue) throws IOException {
        osw.write(60);
        osw.write(aName);
        osw.write(62);
        osw.write(aValue);
        osw.write("</");
        osw.write(aName);
        osw.write(62);
    }

    private class RequestorIntermediary
    implements IURRequestor {
        private IURRequestor mRequestor;
        private ITransport mTransport;

        public RequestorIntermediary(IURRequestor aRequestor, ITransport aTransport) {
            this.mRequestor = this.mRequestor;
            this.mTransport = aTransport;
        }

        public void receiveAsyncException(URResult aResult) {
            TransportManager.this.cleanup(aResult.getResource(), this.mTransport);
            this.mRequestor.receiveAsyncException(aResult);
        }

        public void receiveAsyncResult(URResult aResult) {
            TransportManager.this.cleanup(aResult.getResource(), this.mTransport);
            this.mRequestor.receiveAsyncResult(aResult);
        }
    }
}

