/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.scheduler;

import com.ten60.netkernel.cache.Cache;
import com.ten60.netkernel.container.ComponentImpl;
import com.ten60.netkernel.container.Config;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.MappedRequest;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.module.ModuleManager;
import com.ten60.netkernel.scheduler.BusyAccessorTable;
import com.ten60.netkernel.scheduler.NoAccessorFoundException;
import com.ten60.netkernel.scheduler.PendingRequestMap;
import com.ten60.netkernel.scheduler.RequestState;
import com.ten60.netkernel.scheduler.RequestStatistics;
import com.ten60.netkernel.scheduler.RequestTable;
import com.ten60.netkernel.scheduler.SynchronousRequestor;
import com.ten60.netkernel.scheduler.WorkerThreadPool;
import com.ten60.netkernel.scheduler.debug.Debugger;
import com.ten60.netkernel.transport.TransportInitiatedSession;
import com.ten60.netkernel.urii.IURAccessor;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.URIdentifier;
import com.ten60.netkernel.urii.accessor.AccessorFactory;
import com.ten60.netkernel.urii.aspect.IAspectNetKernelException;
import com.ten60.netkernel.urii.fragment.IFragmentor;
import com.ten60.netkernel.urii.representation.ITransrepresentor;
import com.ten60.netkernel.urrequest.IRequestorSession;
import com.ten60.netkernel.urrequest.IURRequestee;
import com.ten60.netkernel.urrequest.IURRequestor;
import com.ten60.netkernel.urrequest.IURSynchRequestee;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urrequest.URResult;
import com.ten60.netkernel.util.NetKernelError;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.util.XMLReadable;
import com.ten60.netkernel.util.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class Scheduler
extends ComponentImpl
implements IURRequestee,
IURSynchRequestee,
IURRequestor {
    public static final URIdentifier URI = new URIdentifier("netkernel:scheduler");
    private RequestTable mTable = new RequestTable();
    private PendingRequestMap mPendingResults = new PendingRequestMap();
    private WorkerThreadPool mThreadPool;
    private ModuleManager mModuleManager;
    private Cache mCache;
    private Container mContainer;
    private SynchronousRequestor mSynchronousRequestor;
    private BusyAccessorTable mBusyAccessors = new BusyAccessorTable();
    private long mDeadlockPeriod;
    private Debugger mDebugger;
    private Map mSessionToLastRequestMap = Collections.synchronizedMap(new WeakHashMap());
    private Map mRequestThreads = Collections.synchronizedMap(new HashMap());
    private long mTotalTime;
    private int mHouseKeepingFreqDivider;
    private int mDeadlockLevel;
    private RequestState mDeadlockedState;
    private static final int DLL_OK = 0;
    private static final int DLL_INC_THREADS = 1;
    private static final int DLL_KILL = 2;
    private static final int DLL_STOP = 3;
    private RequestStatistics mStats;
    static /* synthetic */ Class class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException;

    public Scheduler() {
        super(URI);
        this.mSynchronousRequestor = new SynchronousRequestor();
        this.mStats = new RequestStatistics();
        this.mDebugger = new Debugger(this);
    }

    public Debugger getDebugger() {
        return this.mDebugger;
    }

    public RequestState getPendingStateFor(URRequest aRequest) {
        return this.mPendingResults.get(aRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public URResult requestSynch(URRequest aRequest) throws NetKernelException {
        aRequest.setRequestor(this.mSynchronousRequestor);
        this.innerRequestAsynch(aRequest, true);
        SynchronousRequestor.ResultStruct result = null;
        try {
            URRequest uRRequest = aRequest;
            // MONITORENTER : uRRequest
            while ((result = this.mSynchronousRequestor.get(aRequest)) == null) {
                RequestState state = this.mTable.takeIfAvailable(aRequest.getSession());
                if (state == null) {
                    long t = System.currentTimeMillis();
                    aRequest.wait();
                    t = System.currentTimeMillis() - t;
                    Scheduler scheduler = this;
                    // MONITORENTER : scheduler
                    this.mTotalTime -= t;
                    // MONITOREXIT : scheduler
                    continue;
                }
                this.processRequest(state);
            }
            // MONITOREXIT : uRRequest
            if (!result.isException) return result.result;
            IURRepresentation resource = result.result.getResource();
            IAspectNetKernelException aspect = (IAspectNetKernelException)result.result.getResource().getAspect(class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException == null ? (class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException = Scheduler.class$("com.ten60.netkernel.urii.aspect.IAspectNetKernelException")) : class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException);
            if (aspect.getError() == null) throw aspect.getException();
            throw aspect.getError();
        }
        catch (InterruptedException e) {
            NetKernelError e2 = new NetKernelError("Interrupted");
            throw e2;
        }
    }

    public void requestAsync(URRequest aRequest) {
        this.innerRequestAsynch(aRequest, false);
    }

    private void innerRequestAsynch(URRequest aRequest, boolean aExecInline) {
        RequestState parentState;
        RequestState state = new RequestState(aRequest);
        URRequest parent = aRequest.getParent();
        if (parent != null && (parentState = this.mPendingResults.get(parent)) != null) {
            parentState.pauseTimer();
        }
        if (aExecInline) {
            this.processRequest(state);
        } else {
            this.mTable.put(state);
        }
    }

    public void start(Container aContainer) throws NetKernelException {
        this.mContainer = aContainer;
        this.mModuleManager = (ModuleManager)aContainer.getComponent(ModuleManager.URI);
        this.mCache = (Cache)aContainer.getComponent(Cache.URI);
        XMLReadable config = ((Config)aContainer.getComponent(Config.URI)).getReadable();
        int threadCount = config.getInt("system/schedulerThreads", 1);
        this.mDeadlockPeriod = config.getInt("system/deadlockPeriod", 8000);
        this.mThreadPool = new WorkerThreadPool("Scheduler", threadCount){

            public void process() {
                Scheduler.this.processRequest();
            }
        };
        this.mThreadPool.start();
    }

    public void stop() {
        this.mThreadPool.stop();
        this.mTable.interrupt();
        try {
            this.mThreadPool.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void releaseBreakpointedState(RequestState aState) {
        switch (aState.getState()) {
            case 1: {
                aState.setState(2);
                this.mTable.put(aState);
                break;
            }
            case 12: {
                aState.setState(13);
                this.mTable.put(aState);
                break;
            }
        }
    }

    protected void processRequest() {
        RequestState state;
        try {
            state = this.mTable.take();
        }
        catch (InterruptedException e) {
            state = null;
        }
        if (state != null) {
            this.processRequest(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(RequestState aState) {
        Thread t = Thread.currentThread();
        this.mRequestThreads.put(aState, t);
        this.mSessionToLastRequestMap.put(aState.getOriginalRequest().getSession(), new Long(System.currentTimeMillis()));
        try {
            boolean workToDo = true;
            block17: while (workToDo) {
                switch (aState.getState()) {
                    case 0: {
                        this.stateMapRequest(aState);
                        continue block17;
                    }
                    case 2: {
                        this.stateTestCache(aState);
                        continue block17;
                    }
                    case 4: {
                        this.stateReturnAccessor(aState);
                        continue block17;
                    }
                    case 5: {
                        workToDo = this.stateRequestRepresentation(aState);
                        continue block17;
                    }
                    case 8: {
                        this.stateReleasedAccessor(aState);
                        continue block17;
                    }
                    case 9: {
                        this.stateFragmentation(aState);
                        continue block17;
                    }
                    case 10: {
                        this.stateTransrepresent(aState);
                        continue block17;
                    }
                    case 11: {
                        this.stateResultReady(aState);
                        continue block17;
                    }
                    case 13: {
                        this.stateReturnResult(aState);
                        continue block17;
                    }
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 12: 
                    case 14: {
                        workToDo = false;
                        continue block17;
                    }
                }
                aState.setException(new NetKernelException("undefined state in processRequest()"));
            }
        }
        catch (Throwable th) {
            if (aState.getState() != 14) {
                URRequest req = aState.getMappedRequest();
                if (req != null) {
                    this.mPendingResults.remove(req);
                }
                aState.setException(th);
                this.mTable.put(aState);
            } else {
                RequestState parentState;
                URRequest parentRequest = aState.getOriginalRequest().getParent();
                if (parentRequest != null && (parentState = this.mPendingResults.remove(parentRequest)) != null) {
                    parentState.setException(th);
                    this.mTable.put(parentState);
                }
            }
        }
        finally {
            this.mRequestThreads.remove(aState);
        }
    }

    public void receiveAsyncResult(URResult aResult) {
        RequestState state = this.mPendingResults.remove(aResult.getRequest());
        if (state != null) {
            state.pauseTimer();
            IURRepresentation resource = aResult.getResource();
            if (resource != null) {
                this.stateReceiveRepresentation(state, resource);
            } else {
                state.setException(new NetKernelException("Null result returned"));
            }
            this.processRequest(state);
        } else {
            SysLogger.log(2, this, "received unexpected result for " + aResult.getRequest().toString());
        }
    }

    public void receiveAsyncException(URResult aResult) {
        RequestState state = this.mPendingResults.remove(aResult.getRequest());
        if (state != null) {
            state.pauseTimer();
            IAspectNetKernelException nkep = (IAspectNetKernelException)aResult.getResource().getAspect(class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException == null ? (class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException = Scheduler.class$("com.ten60.netkernel.urii.aspect.IAspectNetKernelException")) : class$com$ten60$netkernel$urii$aspect$IAspectNetKernelException);
            if (nkep.getError() != null) {
                state.setException(nkep.getError());
            } else {
                state.setException(nkep.getException());
            }
            this.processRequest(state);
        } else {
            SysLogger.log(2, this, "received unexpected result for " + aResult.getRequest().toString());
        }
    }

    private void stateMapRequest(RequestState aState) throws Throwable {
        MappedRequest mappedRequest;
        URRequest uraRequest;
        URRequest originalRequest = aState.getOriginalRequest();
        if (aState.getFragment() != null) {
            originalRequest = originalRequest.rewrite(originalRequest.getURI().withoutFragment());
        }
        if ((uraRequest = (mappedRequest = this.mModuleManager.getAccessorForRequest(originalRequest, false)).getAccessorRequest()) == null) {
            MappedRequest mappedRequest2 = this.mModuleManager.getAccessorForRequest(originalRequest, true);
            ModuleDefinition md = (ModuleDefinition)originalRequest.getContext();
            NoAccessorFoundException e = new NoAccessorFoundException(originalRequest.getURI(), md.getURI(), mappedRequest2.getDebug());
            throw e;
        }
        aState.setMappedRequest(mappedRequest.getMappedRequest());
        aState.setAccessorRequest(uraRequest);
        if (!this.mDebugger.catchBreakpoint(aState)) {
            aState.setState(2);
        }
    }

    private void stateTestCache(RequestState aState) {
        IURRepresentation representation = null;
        try {
            URRequest mapped = aState.getMappedRequest();
            if (aState.getFragment() != null) {
                URRequest mappedWithFrag = mapped.rewrite(mapped.getURI().withFragment(aState.getFragment()));
                representation = this.mCache.get(mappedWithFrag);
                if (representation == Cache.EXPIRED_RESOURCE) {
                    representation = null;
                } else if (representation != null) {
                    aState.setState(10);
                    aState.setUncastResult(representation);
                }
            }
            if (representation == null) {
                representation = this.mCache.get(mapped);
                if (representation == Cache.EXPIRED_RESOURCE) {
                    if (!this.mPendingResults.hasEquivalentInProgress(aState)) {
                        representation = null;
                    }
                } else if (representation != null) {
                    aState.setState(9);
                    aState.setUncastResult(representation);
                }
            }
        }
        catch (NetKernelException e) {
            SysLogger.log(2, this, e.toString());
        }
        if (representation == null) {
            aState.setState(4);
        }
    }

    private void stateReturnAccessor(RequestState aState) throws Throwable {
        IURAccessor accessor;
        URRequest uraRequest = aState.getAccessorRequest();
        IURRepresentation representation = this.mCache.get(uraRequest);
        if (representation == null || representation == Cache.EXPIRED_RESOURCE) {
            accessor = AccessorFactory.createAccessor(uraRequest, this.mContainer);
            URResult result = new URResult(uraRequest, accessor);
            this.mCache.put(result);
        } else {
            accessor = (IURAccessor)representation;
        }
        aState.setAccessor(accessor);
        aState.setState(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stateRequestRepresentation(RequestState aState) throws Throwable {
        boolean result = false;
        IURAccessor accessor = aState.getAccessor();
        if (accessor.getAccessorMeta().supportsRequestType(aState.getOriginalRequest().getType())) {
            boolean accessorAvailable = true;
            boolean isThreadSafe = accessor.getAccessorMeta().isThreadSafe();
            if (!isThreadSafe) {
                aState.setState(7);
                accessorAvailable = this.mBusyAccessors.addBlockedRequest(aState);
            }
            if (accessorAvailable) {
                URRequest mappedRequest = aState.getMappedRequest();
                aState.setState(6);
                this.mPendingResults.put(mappedRequest, aState);
                aState.resumeTimer();
                try {
                    accessor.requestAsync(mappedRequest);
                }
                finally {
                    this.mRequestThreads.put(aState, Thread.currentThread());
                }
            }
        } else {
            String message = URRequest.typeToString(aState.getOriginalRequest().getType()) + " unsupported on " + accessor.getURI().toString();
            throw new NetKernelException("Unsupported Request Type", message, aState.getMappedRequest().toString());
        }
        return result;
    }

    private void stateReleasedAccessor(RequestState aState) {
        URRequest mappedRequest = aState.getMappedRequest();
        aState.setState(6);
        this.mPendingResults.put(mappedRequest, aState);
        aState.getAccessor().requestAsync(mappedRequest);
    }

    private void stateReceiveRepresentation(RequestState aState, IURRepresentation aResult) {
        this.releaseAccessorLock(aState);
        aState.setUncastResult(aResult);
        aState.setState(9);
        aState.setResultNeedsCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateFragmentation(RequestState aState) throws Throwable {
        if (aState.getFragment() == null) {
            aState.setState(10);
        } else {
            URRequest parent = aState.getOriginalRequest();
            URRequest request = new URRequest(parent.getURI(), null, parent.getSession(), null, 64, parent.getCWU(), parent, parent.getAspectClass());
            List superStack = parent.getSuperStackClone();
            superStack.add(parent.getContext());
            request.setCurrentContext(parent.getContext(), superStack);
            IURRepresentation from = aState.getUncastResult();
            request.addArg(parent.getURI().withoutFragment(), from);
            IFragmentor fragmentor = this.mModuleManager.getFragmentorFor(request);
            if (fragmentor == null) {
                String fragment = aState.getOriginalRequest().getURI().getFragment();
                String mime = from.getMeta().getMimeType();
                throw new NetKernelException("Unrecognised Fragment Identifier", "No fragmentor found for a fragment identifier of [#" + fragment + "] on resource of type [" + mime + "]", null);
            }
            try {
                URResult result = new URResult(aState.getMappedRequest(), aState.getUncastResult());
                this.mCache.put(result);
            }
            catch (NetKernelException e) {
                SysLogger.log(2, this, e.toString());
            }
            long startTime = System.currentTimeMillis();
            RequestState state = new RequestState(request);
            this.mPendingResults.put(request, state);
            boolean error = true;
            try {
                state.resumeTimer();
                IURRepresentation result = fragmentor.fragment(request);
                aState.setUncastResult(result);
                aState.setResultNeedsCaching();
                error = false;
                if (result.getMeta().isIntermediate() != aState.getUncastResult().getMeta().isIntermediate()) {
                    SysLogger.log(2, this, "Fragmentor " + fragmentor.getClass().getName().toString() + " not preserving isIntermediate()");
                }
                Object var13_15 = null;
                state.pauseTimer();
                this.mStats.addStatisticsFor(fragmentor, state.getCummulativeTime(), state.getRequestTime(), error);
                this.mPendingResults.remove(request);
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                state.pauseTimer();
                this.mStats.addStatisticsFor(fragmentor, state.getCummulativeTime(), state.getRequestTime(), error);
                this.mPendingResults.remove(request);
                throw throwable;
            }
            aState.setState(10);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stateTransrepresent(RequestState aState) throws Throwable {
        if (aState.getUncastResult().hasAspect(aState.getOriginalRequest().getAspectClass())) {
            aState.setResult(aState.getUncastResult());
            aState.setState(11);
            return;
        }
        if (this.transrepresent(aState)) return;
        if (aState.getOriginalRequest().getType() == 1 && !aState.resultNeedsCaching()) {
            aState.setState(4);
            return;
        }
        StringBuffer fromString = new StringBuffer(128);
        IURRepresentation from = aState.getUncastResult();
        Class to = aState.getOriginalRequest().getAspectClass();
        Collection fromInterfaces = from.getAspects();
        Iterator i = fromInterfaces.iterator();
        while (i.hasNext()) {
            Object aspect = i.next();
            fromString.append(aspect.getClass().getName());
            if (!i.hasNext()) continue;
            fromString.append(", ");
        }
        throw new NetKernelException("No Transreptor Found", "No suitable transreptor found for conversion from [" + fromString + "] to [" + to.getName() + "]", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean transrepresent(RequestState aState) throws Throwable {
        IURRepresentation from = aState.getUncastResult();
        Class to = aState.getOriginalRequest().getAspectClass();
        ITransrepresentor transreptor = this.mModuleManager.getTransrepresentorFor(from, to, aState.getOriginalRequest());
        long startTime = System.currentTimeMillis();
        if (transreptor != null) {
            URRequest parent = aState.getMappedRequest();
            URRequest request = new URRequest(parent.getURI(), null, parent.getSession(), null, 32, parent.getCWU(), parent, parent.getAspectClass());
            List superStack = parent.getSuperStackClone();
            superStack.add(parent.getContext());
            request.setCurrentContext(parent.getContext(), superStack);
            request.addArg(URRequest.URI_SYSTEM, from);
            RequestState state = new RequestState(request);
            this.mPendingResults.put(request, state);
            try {
                state.resumeTimer();
                IURRepresentation result = transreptor.transrepresent(from, request);
                aState.setResult(result);
                aState.setResultNeedsCaching();
                if (result.getMeta().isIntermediate() != aState.getUncastResult().getMeta().isIntermediate()) {
                    SysLogger.log(2, this, "Transreptor " + transreptor.getClass().getName().toString() + " not preserving isIntermediate()");
                }
                Object var13_11 = null;
                state.pauseTimer();
                this.mStats.addStatisticsFor(transreptor, state.getCummulativeTime(), state.getRequestTime(), aState.getResult() == null);
                this.mPendingResults.remove(request);
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                state.pauseTimer();
                this.mStats.addStatisticsFor(transreptor, state.getCummulativeTime(), state.getRequestTime(), aState.getResult() == null);
                this.mPendingResults.remove(request);
                throw throwable;
            }
            aState.setState(11);
        }
        return transreptor != null;
    }

    private void stateResultReady(RequestState aState) {
        if (!this.mDebugger.catchBreakpoint(aState)) {
            aState.setState(13);
        }
    }

    private void stateReturnResult(RequestState aState) throws Throwable {
        RequestState state;
        URRequest parent;
        boolean wasException = aState.wasException();
        this.mStats.addStatisticsFor(aState, wasException);
        URRequest originalRequest = aState.getOriginalRequest();
        if (aState.resultNeedsCaching()) {
            try {
                URRequest request = aState.getMappedRequest();
                if (aState.getFragment() != null) {
                    request = request.rewrite(request.getURI().withFragment(aState.getFragment()));
                }
                URResult result = new URResult(request, aState.getResult());
                this.mCache.put(result);
            }
            catch (NetKernelException e) {
                SysLogger.log(2, this, e.toString());
            }
            this.mPendingResults.notifyOfAvailableResult(aState, this.mTable);
        }
        if ((parent = originalRequest.getParent()) != null && (state = this.mPendingResults.get(parent)) != null) {
            state.resumeTimer();
        }
        aState.setState(14);
        IURRequestor requestor = originalRequest.getRequestor();
        URResult result = new URResult(aState.getOriginalRequest(), aState.getResult());
        if (wasException) {
            this.releaseAccessorLock(aState);
            requestor.receiveAsyncException(result);
        } else {
            requestor.receiveAsyncResult(result);
        }
    }

    private void releaseAccessorLock(RequestState aState) {
        RequestState released;
        IURAccessor accessor = aState.getAccessor();
        if (accessor != null && (released = this.mBusyAccessors.releaseAccessor(accessor.getURI())) != null) {
            if (released.getState() == 7) {
                released.setState(8);
                this.mTable.put(released);
            } else {
                SysLogger.log(3, this, "scheduler unstable- accessor blocked state wrong");
            }
        }
    }

    public void write(OutputStream aStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(aStream);
        osw.write("<scheduler>");
        long work = this.mStats.write(osw);
        this.writeSessions(osw);
        osw.write("</scheduler>");
        osw.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSessions(Writer aWriter) throws IOException {
        aWriter.write("<sessions>");
        long now = System.currentTimeMillis();
        Map map = this.mSessionToLastRequestMap;
        synchronized (map) {
            Iterator i = this.mSessionToLastRequestMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                long time = (Long)entry.getValue();
                IRequestorSession session = (IRequestorSession)entry.getKey();
                RequestState state = this.mPendingResults.getOldestStateForSession(session);
                if (state == null) continue;
                String uriString = state.getOriginalRequest().getURI().toString();
                long start = state.getOriginalRequest().getTime();
                aWriter.write("<session>");
                XMLUtils.write(aWriter, "id", Long.toString(session.getId()));
                XMLUtils.write(aWriter, "uri", XMLUtils.escape(uriString));
                XMLUtils.write(aWriter, "age", Long.toString(now - start));
                XMLUtils.write(aWriter, "active", Long.toString(now - time));
                aWriter.write("</session>");
            }
        }
        aWriter.write("</sessions>");
    }

    public int killSession(long aSession, String aMessage) throws InterruptedException {
        int i;
        TransportInitiatedSession session = new TransportInitiatedSession(aSession);
        int result = 0;
        for (i = 0; i < 10 && result == 0; ++i) {
            if (this.mPendingResults.kill(session, this.mRequestThreads, this.mTable, i == 0, aMessage)) {
                result = 1;
                continue;
            }
            Thread.currentThread();
            Thread.sleep(20L);
        }
        if (result == 1) {
            for (i = 0; i < 10 && result == 1; ++i) {
                Thread.currentThread();
                Thread.sleep(200L);
                RequestState state = this.mPendingResults.getNewestStateForSession(session);
                if (state != null) continue;
                result = 2;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPeriodicHouseKeeping() {
        this.mHouseKeepingFreqDivider = (this.mHouseKeepingFreqDivider + 1) % 4;
        if (this.mHouseKeepingFreqDivider != 0) {
            return;
        }
        long oldestTime = Long.MAX_VALUE;
        RequestState oldestState = null;
        Map map = this.mSessionToLastRequestMap;
        synchronized (map) {
            Iterator i = this.mSessionToLastRequestMap.entrySet().iterator();
            while (i.hasNext()) {
                RequestState state;
                Map.Entry entry = i.next();
                long time = (Long)entry.getValue();
                if (time >= oldestTime || (state = this.mPendingResults.getNewestStateForSession((IRequestorSession)entry.getKey())) == null) continue;
                oldestTime = time;
                oldestState = state;
            }
        }
        long age = System.currentTimeMillis() - oldestTime;
        if (age < this.mDeadlockPeriod) {
            oldestState = null;
        }
        if (this.mDeadlockedState != oldestState && this.mDeadlockedState != null) {
            if (this.mDeadlockLevel == 1) {
                SysLogger.log(6, this, "Deadlock resolved by increasing thread count");
            }
            this.mDeadlockedState = null;
            this.mDeadlockLevel = 0;
        }
        if (oldestState != null) {
            this.mDeadlockedState = oldestState;
            this.kill(this.mDeadlockLevel, this.mDeadlockedState);
        }
    }

    private void kill(int aLevel, RequestState aState) {
        long age = System.currentTimeMillis() - aState.getOriginalRequest().getTime();
        String message = aState.getMappedRequest().getURI() + " (Lifeless for " + age + "ms)";
        switch (aLevel) {
            case 0: {
                int threadCount = this.mThreadPool.threadCount() + 1;
                this.mThreadPool.setCount(threadCount);
                this.mDeadlockLevel = 1;
                SysLogger.log(2, this, "deadlock detected; temporarily increasing thread count to " + threadCount + " for " + message);
                break;
            }
            case 1: {
                SysLogger.log(3, this, "killing deadlocked request " + message);
                int threadCount = this.mThreadPool.threadCount() - 1;
                this.mThreadPool.setCount(threadCount);
                this.mDeadlockLevel = 2;
                IRequestorSession session = aState.getOriginalRequest().getSession();
                try {
                    int status = this.killSession(session.getId(), "Deadlock detected");
                }
                catch (InterruptedException e) {}
                break;
            }
            case 2: {
                this.mDeadlockLevel = 3;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

