/*
 * Decompiled with CFR 0.152.
 */
package com.ten60.netkernel.module.accessor;

import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.module.ModuleDefinition;
import com.ten60.netkernel.urii.IURMeta;
import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import com.ten60.netkernel.urii.representation.SimpleRepresentationImpl;
import com.ten60.netkernel.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public final class ModuleResourceRepresentation
extends SimpleRepresentationImpl
implements IAspectReadableBinaryStream {
    private String mPath;
    private URLConnection mConnection;
    private int mLength = -1;
    private long mTimestamp;
    private String mMime;
    private long mLastChecked;
    private long mExpiryOffset;
    private String mEncoding;
    private URL mURL;
    private File mFile;

    public ModuleResourceRepresentation(String aPath, ModuleDefinition aModule, Container aContainer, long aExpiryOffset) throws IOException {
        super(null);
        this.mMeta = this.createMeta();
        this.mPath = aPath;
        this.mExpiryOffset = aExpiryOffset;
        this.mURL = aModule.getResource(this.mPath);
        if (this.mURL == null) {
            throw new IOException();
        }
        if (this.mURL.getProtocol().equals("file")) {
            this.mFile = new File(URI.create(this.mURL.toString()));
            this.mTimestamp = this.mFile.lastModified();
        } else {
            String url = this.mURL.toString();
            String unescaped = Utils.decode(url);
            this.mURL = new URL(unescaped);
        }
        this.ensureOpenConnection();
        this.mMime = this.mConnection.getContentType();
        this.mLength = this.mConnection.getContentLength();
        this.mEncoding = this.mConnection.getContentEncoding();
    }

    public int getContentLength() {
        return this.mLength;
    }

    public void write(OutputStream aStream) throws IOException {
        this.ensureOpenConnection();
        InputStream is = this.mConnection.getInputStream();
        this.mConnection = null;
        Utils.pipe(is, aStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        InputStream is;
        ModuleResourceRepresentation moduleResourceRepresentation = this;
        synchronized (moduleResourceRepresentation) {
            this.ensureOpenConnection();
            is = this.mConnection.getInputStream();
            this.mConnection = null;
        }
        return is;
    }

    private void ensureOpenConnection() throws IOException {
        this.mConnection = this.mURL.openConnection();
        this.mLastChecked = this.mFile == null ? Long.MAX_VALUE : System.currentTimeMillis() + this.mExpiryOffset;
    }

    private IURMeta createMeta() {
        IURMeta meta = new IURMeta(){

            public boolean isExpired() {
                boolean result;
                if (ModuleResourceRepresentation.this.mLastChecked == 0L) {
                    result = true;
                } else if (ModuleResourceRepresentation.this.mFile == null || ModuleResourceRepresentation.this.mLastChecked > System.currentTimeMillis()) {
                    result = false;
                } else {
                    boolean bl = result = ModuleResourceRepresentation.this.mFile.lastModified() > ModuleResourceRepresentation.this.mTimestamp;
                    if (result) {
                        ModuleResourceRepresentation.this.mLastChecked = 0L;
                    } else {
                        ModuleResourceRepresentation.this.mLastChecked = System.currentTimeMillis() + ModuleResourceRepresentation.this.mExpiryOffset;
                    }
                }
                return result;
            }

            public long getPessimisticExpiryTime() {
                return ModuleResourceRepresentation.this.mLastChecked;
            }

            public String getMimeType() {
                return ModuleResourceRepresentation.this.mMime;
            }

            public int getCreationCost() {
                return 4;
            }

            public int getUsageCost() {
                return 4 + (ModuleResourceRepresentation.this.mLength >> 10);
            }

            public boolean isIntermediate() {
                return false;
            }

            public boolean isContextSensitive() {
                return false;
            }

            public String toString() {
                return ModuleResourceRepresentation.this.mPath;
            }
        };
        return meta;
    }

    public String getEncoding() {
        return this.mEncoding;
    }
}

