package com.streamsicle.util;

import java.util.Vector;
// Import log4j classes.
import org.ten60.orchextra.*;

public class QuickSort {

   /**
    * Quicksorts an array using Hoare's alg and using 'toString' as the keys.
    *
    * @param a       an Object array
    * @param lo0     left boundary of array partition
    * @param hi0     right boundary of array partition
    */
    private static void qsort(Object[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;

        if ( hi0 > lo0) {
            /* Arbitrarily establishing partition element as the midpoint of
            * the array.
            */
            Object mid = a[ ( lo0 + hi0 ) / 2 ];

            // loop through the array until indices cross
            while ( lo <= hi ) {
                /* find the first element that is greater than or equal to
                * the partition element starting from the left Index.
                */
                while (( lo < hi0 ) && ( compare(a[lo], mid) < 0 ))
                    ++lo;

                /* find an element that is smaller than or equal to
                * the partition element starting from the right Index.
                */
                while (( hi > lo0 ) && ( compare(a[hi], mid) > 0 ))
                    --hi;

                // if the indexes have not crossed, swap
                if ( lo <= hi ) {
                    swap(a, lo, hi);

                    ++lo;
                    --hi;
                }
            }

            /* If the right index has not reached the left side of array
            * must now sort the left partition.
            */
            if ( lo0 < hi )
                qsort( a, lo0, hi );

            /* If the left index has not reached the right side of array
            * must now sort the right partition.
            */
            if ( lo < hi0 )
                qsort( a, lo, hi0 );
        }
    }

    private static int compare (Object a, Object b) {
	return (a.toString().compareTo(b.toString()));
    }

    private static void swap(Object[] a, int i, int j) {
        Object temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    public static void sort(Object[] a) {
        qsort(a, 0, a.length - 1);
    }

    public static void sort(Object[] a, int length) {
        qsort(a, 0, length - 1);
    }

    public static void main (String[] args) {
	sort(args);
	for (int i = 0; i < args.length; i++) {
            
            OrchextraAccessor.log(OrchextraAccessor.INFO, null, args[i]);
        }
    }
}
