package com.streamsicle.fluid;

import java.io.*;

/**
 * A descriptor describing the MP3 media file using
 * the information found in the ID3 tag or parts
 * of the filename if no tag was found.
 *
 * @author Lars Samuelsson
 */
public class MP3Descriptor implements Descriptor {
    /** 
     * Creates an MP3Descriptor object.
     */
    public MP3Descriptor() {
	super();
    }
    /** 
     * Required by the Descriptor interface.
     * 
     * @param type A type
     * @return     true if type is "mp3" or "mpeg3"
     */
    public boolean describes(String type) {
	return type.equals("mp3") || type.equals("mpeg3");
    }
    /**
     * Returns a description of the file.
     * 
     * Will return the same information as the 
     * getCompleteName method in the ID3Tag.
     * 
     * @return Artist and track if available
     */
    public String describe(Object obj) {
	if(!(obj instanceof String))
	    return null;
	String filename = (String) obj;
	ID3Tag tag = null;
	try {
	    tag = new ID3Tag(filename);
	}
	catch(IOException e) {
	    return null;
	}
	if(tag == null) 
	    return null;
	return tag.getCompleteName();
    }
}
