/*
 * PHPScriptEngineAccessor.java
 *
 * Created on October 11, 2007, 10:28 AM
 */

package org.ten60.netkernel.php.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.php.representation.CompiledPHPScriptAspect;
import com.ten60.netkernel.urii.aspect.*;
import javax.script.*;
import com.caucho.quercus.script.*;
import java.io.*;
import java.util.*;

import org.ten60.netkernel.layer1.util.SuperStackClassLoader;

/**
 *  PHP Script Engine - Based on Caucho Quercus
 * @author  pjr
 */
public class PHPScriptEngineAccessor extends NKFAccessorImpl
{	
	/** Creates a new instance of PHPScriptEngineAccessor */
	public PHPScriptEngineAccessor()
	{	super(SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);	
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	//Thread.currentThread().setContextClassLoader(new SuperStackClassLoader(context.getKernelHelper().getThisKernelRequest()));
		CompiledPHPScriptAspect sa=(CompiledPHPScriptAspect)context.sourceAspect("this:param:operator", CompiledPHPScriptAspect.class);
		ScriptContext sc=new SimpleScriptContext();
		StringWriter sw=new StringWriter(1024);
		sc.setWriter(sw);
		sc.setErrorWriter(new OutputStreamWriter(System.out));
		Bindings b=new SimpleBindings();
		b.put("context", context);
		sc.setBindings(b, ScriptContext.ENGINE_SCOPE);
		context.setCWU(context.getThisRequest().getArgument("operator"));
		QuercusCompiledScript script=(QuercusCompiledScript)sa.getCompiledScript();
		script.eval(sc, context);
		if(!context.isResponseSet())
		{	INKFResponse resp=context.createResponseFrom(new org.ten60.netkernel.layer1.representation.StringAspect(sw.toString()));
			String type=context.getThisRequest().getActiveType();
			int restpathstart=type.indexOf("/");
			if(restpathstart>0)
			{	resp.setMimeType(type.substring(restpathstart+1));
			}
			else
			{	resp.setMimeType("text/html");
			}
			resp.setCacheable();
		}
	}
}
