/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: FOPAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2003/08/01 07:04:13 $
 *****************************************************************************/
package org.ten60.xslfo.accessor;


import com.ten60.netkernel.urii.*;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import java.io.*;
import org.xml.sax.*;
import org.apache.fop.apps.*;
import org.apache.fop.messaging.*;

/**
 * XSL:FO Renderer using Apache FOP
 * http://xml.apache.org/fop/
 * @author  pjr
 */
public class FOPAccessor extends XAccessor{
	
	public static final String MIME_PDF="application/pdf";
	public static final String MIME_SVG="image/svg";
	public static final String MIME_PCL="application/pcl";
	public static final String MIME_PRINT="application/pcl";
	public static final String MIME_AWT="application/awt";
	public static final String MIME_TEXT="text/plain";
	public static final String MIME_PS="application/ps";
	public static final String MIME_MIF="application/mif";
	public static final String MIME_XML="text/xml";
	
	/** Creates a new instance of FOPAccessor */
	public FOPAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, true, false);
	}
	
	/** Abstract method to be implemented in subclass.
	 * @return Either the result as a Document or a Reader.
	 * @param aHelper The helper class that provides access to the operator,
	 * operand, and parameters.
	 * @throws AccessViolationException Thrown if we fail to access any of the beans
	 * @throws DocumentAccessorException Thrown if we fail for any reason.
	 *
	 */
	public IURRepresentation source(XAHelper aHelper) throws Throwable
	{
		StringReader fo=new StringReader(aHelper.getOperand().getXDA().toString());
		IXDAReadOnly opt=aHelper.getOperator().getXDA();
		String type=opt.getText("/xslfo-fop/type",true);
		if (type==null) throw new Exception("Operator fop document requires type element");
		Driver driver = new Driver();
		
		String mime=null;
		if(type.equals("pdf"))
		{	driver.setRenderer(Driver.RENDER_PDF);
			mime=MIME_PDF;
		}
		else if(type.equals("svg"))
		{	driver.setRenderer(Driver.RENDER_SVG);
			mime=MIME_SVG;
		}
		else if(type.equals("pcl"))
		{	driver.setRenderer(Driver.RENDER_PCL);
			mime=MIME_PCL;
		}
		else if(type.equals("awt"))
		{	driver.setRenderer(Driver.RENDER_AWT);
			mime=MIME_AWT;
		}
		else if(type.equals("print"))
		{	driver.setRenderer(Driver.RENDER_PRINT);
			mime=MIME_PRINT;
		}
		else if(type.equals("text"))
		{	driver.setRenderer(Driver.RENDER_TXT);
			mime=MIME_TEXT;
		}
		else if(type.equals("ps"))
		{	driver.setRenderer(Driver.RENDER_PS);
			mime=MIME_PS;
		}
		else if(type.equals("mif"))
		{	driver.setRenderer(Driver.RENDER_MIF);
			mime=MIME_MIF;
		}
		else if(type.equals("xml"))
		{	driver.setRenderer(Driver.RENDER_XML);
			mime=MIME_XML;
		}
		else throw new Exception("Operator fop document requires type [pdf, svg, pcl, awt, print, text, ps, mif, xml]");
        
		//Render Output
		ByteArrayOutputStream baos=new ByteArrayOutputStream(10000);
        try {
            driver.setOutputStream(baos);
            driver.setInputSource(new InputSource(fo));
            driver.run();
			baos.flush();
			IURMeta meta = aHelper.getDependencyMeta(mime,128);
			return ByteArrayAspect.create(meta, baos.toByteArray());
        } finally {
            baos.close();
        }
    }
}
	

