/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: MultiRepresentationImpl.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:23:31 $
 *****************************************************************************/

package org.ten60.netkernel.layer1.representation;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.*;
import java.util.*;
/**
 * Implementation of IURRepresentation that can hold may IURAspects
 * @author  tab
 */
public final class MultiRepresentationImpl implements IURRepresentation
{	/** the list of aspects */
	private List mAspects;
	/** our meta */
	private IURMeta mMeta;
	
	/** Construct a new MultiRepresentationImpl
	 * @param aMeta the meta the representation should hold
	 * @param aInitialSize the initial size of the list to hold aspects
	 */
	public MultiRepresentationImpl(IURMeta aMeta, int aInitialSize)
	{	mMeta=aMeta;
		mAspects = new ArrayList(aInitialSize);
	}
	/** Add an aspect to the representation
	 * @param aAspect the aspect to add
	 */
	public void addAspect(IURAspect aAspect)
	{	mAspects.add(aAspect);
	}
	
	/** Add all aspects of another representation
	 * @param aRepresentation the other representation
	 */
	public void addAspectsOf(IURRepresentation aRepresentation)
	{	for (Iterator i = aRepresentation.getAspects().iterator(); i.hasNext(); )
		{	IURAspect aspect = (IURAspect)i.next();
			mAspects.add(aspect);
		}
	}
	
	/** @return the meta 
	 */
	public IURMeta getMeta()
	{	return mMeta;
	}

	/** Return true if this representation can return an aspect which implements the given interface
	 * @param aAspectClass a IURAspect class object for an aspect to test for
	 * @return true if any of the aspects which this representation holds implement the given interface
	 */
	public boolean hasAspect(Class aAspectClass)
	{	boolean result = false;
		for (int i=mAspects.size()-1; i>=0; i--)
		{	IURAspect aspect = (IURAspect)mAspects.get(i);
			if (aAspectClass.isAssignableFrom(aspect.getClass()))
			{	result = true;
				break;
			}
		}
		return result;
	}
	
	/** Return the first aspect which implements the given interface class
	 * @return the aspect, null if none is found
	 */
	public IURAspect getAspect(Class aAspectClass)
	{	IURAspect result = null;
		for (int i=mAspects.size()-1; i>=0; i--)
		{	IURAspect aspect = (IURAspect)mAspects.get(i);
			if (aAspectClass.isAssignableFrom(aspect.getClass()))
			{	result = aspect;
				break;
			}
		}
		return result;
	}
	
	/** Return a collection of all unique aspects that this representation exhibits */
	public Collection getAspects()
	{	return mAspects;
	}
	
	
}
