/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFResponse.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/09/03 14:25:34 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;
import com.ten60.netkernel.urii.IURAspect;
/**
 * The response to be issued as the result of the invocation of an accessor
 * @author  tab
 */
public interface INKFResponse
{
	/** Sets the creation cost of this response over and above the
	 * accumulated cost of any subrequests, by default 0.
	 * @param aCost
	 */
	void setCreationCost(int aCost);
	
	/** Sets the usage cost of this response over and above the
	 * accumulated cost of any subrequests, by default 0.
	 * @param aCost
	 */
	void setUsageCost(int aCost);
	
	/** Sets the mimetype of this response. By default the mimetype
	 * will be "content/unknown" if created from an aspect, or it
	 * will inherit the mimetype of the representation that it was
	 * created from.
	 * @param aType
	 */
	void setMimeType(String aType);
	
	/** Forces the response to be immediately expired so it and
	 * any derived results are uncacheable. By default a response
	 * will inherit expiry from all subrequests which it was derived from.
	 */
	void setExpired();
	
	/** Forces a specific expiry period (in milliseconds) on the response
	 * @param aPeriod the number of milliseconds for which the response is
	 * valid
	 */
	void setExpiryPeriod(long aPeriod);
	
	/** Declares that the response may have merit in being cached. By default
	 * the results from accessors are declared to be intermediate and will
	 * not usually be cached. */
	void setCacheable();
	
	/** Add an additional aspect into a response. This may be useful for transreptors
	 * which want to preserve aspects from the original representation
	 */
	 void addAspect(IURAspect aAspect);
}