/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: DataSchemeAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2004/06/21 10:23:31 $
 *****************************************************************************/

package org.ten60.netkernel.layer1.accessor;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;

import java.util.*;
import java.net.*;
/**
 * Accessor for data: scheme IETF RFC2397  http://www.ietf.org/rfc/rfc2397.txt
 * @author  pjr
 */
public class DataSchemeAccessor extends ActiveAccessorImpl
{
	
	/** Creates a new instance of DataSchemeAccessor */
	public DataSchemeAccessor()
	{	super(4, true);	
	}
	
	public void requestAsync(com.ten60.netkernel.urrequest.URRequest aRequest)
	{	URResult result=null;
		boolean error=false;
		try
		{	if(aRequest.getType()==URRequest.RQT_SOURCE)
			{	IURRepresentation newres=data(aRequest);
				result=new URResult(aRequest, newres);
			}
			else
			{	throw new Exception("Data is literal only supports SOURCE");
			}
		}
		catch(Throwable e)
		{	NetKernelException nke=new NetKernelException("Exception for "+aRequest.getURI().toString());
			nke.addCause(e);
			result= new URResult(aRequest, NetKernelExceptionAspect.create(nke));
			error=true;
		}
			
		if(error)
		{	getScheduler().receiveAsyncException(result);
		}
		else getScheduler().receiveAsyncResult(result);
	}	

	/*  Parse Data URI into representation.
	 */
	private IURRepresentation data(URRequest aRequest) throws Throwable
	{	String datauri=URI.create(aRequest.getURI().toString()).getSchemeSpecificPart();
		//Parse data URI
		int dataseparator=datauri.indexOf(',');
		byte[] bytes=null;
		String data=datauri.substring(dataseparator+1);
		String tobeparsed=datauri.substring(0,dataseparator);
		if(datauri.matches(".*;base64.*"))
		{	bytes=Base64.decode(data);
			tobeparsed=tobeparsed.replaceAll(";base64", "");
		}
		else bytes=CompoundURIdentifier.decode(data).getBytes();
		
		String mimetype="text/plain";
		String encoding="US-ASCII";
		
		//Find the mimetype
		if(tobeparsed.length()>0)
		{	dataseparator=tobeparsed.indexOf(';');
			if(dataseparator==-1) mimetype=tobeparsed;
			else
			{	mimetype=tobeparsed.substring(0,dataseparator);
				//Find the parameters
				tobeparsed=tobeparsed.substring(dataseparator+1);
				StringTokenizer st=new StringTokenizer(tobeparsed,"=");
				if(st.nextToken().toLowerCase().matches("charset"))
				{	encoding=st.nextToken();
				}
			}
		}
		IURMeta meta = new TimedExpiryMeta(mimetype,System.currentTimeMillis()+TimedExpiryMeta.ONE_DAY , 8);
		IURAspect aspect = new ByteArrayAspect(bytes,encoding);
		return new MonoRepresentationImpl(meta,aspect);
	}
}
