/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: XRLLinker.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2006/03/02 10:52:05 $
 *****************************************************************************/
package org.ten60.docxter2;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;

import com.ten60.netkernel.util.SysLogger;
import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;

import org.w3c.dom.*;
import java.util.*;
/**
 * XRL Linker accessor
 * @author  Tony Butterfield
 */
public class XRLLinker extends NKFAccessorImpl
{
	public static final String ARG_TEMPLATE="template";
	public static final String ARG_CONTENT="content";
	public static final String XRL_SCHEME="xrl:";
	public static final String XRL_NS="http://1060.org/xrl";
	public static final String CONTENT="content";
	public static final String EXCEPTION_ID = "XRL Failure";
	
	/** Creates a new instance of XRLMapper */
	public XRLLinker()
	{	super(0,true,INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper aContext) throws Exception
	{
		//resolve link table resource
		ILinkTableAspect linkTable;
		if (aContext.getThisRequest().getArgument("operator")!=null)
		{	linkTable = (ILinkTableAspect)aContext.sourceAspect("this:param:operator",ILinkTableAspect.class);
		}
		else
		{	linkTable = (ILinkTableAspect)aContext.sourceAspect(GTPUtils.DEFAULT_LINKS.toString(),ILinkTableAspect.class);
		}
		
		int cost=4; //accumulate cost on each operation performed
		String templateURI = aContext.getThisRequest().getArgument(ARG_TEMPLATE);
		if (templateURI==null)
		{	throw new NKFException("Template argument must be supplied");
		}
		String contentURI = aContext.getThisRequest().getArgument(ARG_CONTENT);
		Link templateLink = lookupLink(templateURI,true,contentURI,linkTable);
		if (templateLink==null)
		{	throw new NKFException("template not found",null, templateURI);
		}
		IURRepresentation templateRep = GTPUtils.resolveLink(templateLink,true,null,aContext,IXAspect.class);
		
		IXAspect templateXML = (IXAspect)templateRep.getAspect(IXAspect.class);
		Document d=(Document)org.ten60.netkernel.xml.util.XMLUtils.getInstance().safeDeepClone(templateXML.getReadOnlyDocument());
		
		//Setup DOM recursion
		String activeType =aContext.getThisRequest().getActiveType();
		boolean tolerant=activeType.equals("xrl-tolerant") || activeType.equals("xrl-html-tolerant");
		References refs=new References();
		refs.tolerant=tolerant;
		refs.templateRep=templateRep;
		refs.cost=cost;
		refs.templateURI=templateURI;
		refs.contentURI=contentURI;
		refs.linkTable=linkTable;
		refs.aHelper=aContext;
		recurse(d, refs);
		cost=refs.cost;
		
		//This stuff is the same as XRL v1
		DOMXDA templatexda=new DOMXDA(d,false);
		// process all xrl:eval elements
		if(refs.eval)
		{	for (IXDAIterator i = templatexda.iterator("//xrl:eval[@xpath]"); i.hasNext(); )
			{	i.next();
				String xpath = i.eval("@xpath").getStringValue();
				String fallback = "";
				try
				{	String value = i.eval(xpath).getStringValue();
					if (value.length()==0)
					{	fallback = i.eval("@fallback").getStringValue();
						if (fallback.length()>0)
						{	value = i.eval(fallback).getStringValue();
						}
					}
					String att = i.eval("@attribute").getStringValue();
					if (att.length()==0)
					{	i.replaceByText(".", value);
					}
					else
					{	i.appendPath("..", "@"+att, value);
						i.delete(".");
					}
					cost+=1;
				}
				catch (Exception e)
				{	NKFException nke = new NKFException(EXCEPTION_ID, "failed to process xrl:eval xpath="+xpath+" fallback="+fallback, templateURI.toString()+" "+contentURI.toString());
					nke.addCause(e);
					throw nke;				
				}
			}
		}
		
		// process all xrl:include[xpath] elements
		if(refs.xpath)
		{	for (IXDAIterator i = templatexda.iterator("//xrl:include[@xpath]"); i.hasNext(); )
			{	i.next();
				String xpath = i.eval("@xpath").getStringValue();
				try
				{	i.replace(i, xpath, ".");
					cost+=2;
				}
				catch (Exception e)
				{	if(!tolerant)
					{	NKFException nke = new NKFException(EXCEPTION_ID, "failed to process xrl:include xpath="+xpath, templateURI.toString()+" "+contentURI.toString());
						nke.addCause(e);
						throw nke;
					}
				}
			}
		}

		// determine if we should do a special mimetype
		String mimeType="text/xml";
		if (activeType.equals("xrl-html") || activeType.equals("xrl-html-tolerant"))
		{	mimeType="text/html";
		}
		
		INKFResponse response = aContext.createResponseFrom(new DOMXDAAspect(templatexda));
		response.setMimeType(mimeType);
		response.setCreationCost(cost);
	}
	
	private Link lookupLink(String aURI,boolean aInternal,String aContent, ILinkTableAspect aTable)  throws NKFException
	{	return innerLookupLink(aURI, aInternal, aContent, Collections.EMPTY_LIST, aTable);
	}
	
	private Link innerLookupLink(String aURI, boolean aInternal,  String aContent,List aTraversedLinks, ILinkTableAspect aTable) throws NKFException
	{	Link result = null;
		if (aURI.startsWith(XRL_SCHEME))
		{	String name = aURI.substring(XRL_SCHEME.length());
			if (name.equals(CONTENT))
			{	if (aContent!=null)
				{	result = lookupLink(aContent, aInternal, null,aTable);
				}
				else
				{	throw new NKFException("No Content","xrl:content referenced but no content argument supplied",null);
				}
			}
			else
			{	Link link = aTable.getLinkWithName(name);
				if (link!=null)
				{	String uri = aInternal?link.getInternal():link.getExternal();
					if (uri!=null)
					{
						if (uri.startsWith(XRL_SCHEME))
						{	if (aTraversedLinks.contains(uri))
							{	log( "circularity in "+uri,"","");
								return null;
							}
							List links = new ArrayList(aTraversedLinks);
							links.add(uri);
							result = innerLookupLink(uri, aInternal,aContent,links,aTable);
						}
						else
						{	result = link;
						}
					}
				}
			}
		}
		else
		{	result = new Link(null,aURI,aURI,null); // literal value
		}
		return result;
	}
	
	private void log(String aMessage, String templateURI, String contentURI)
	{	String message = "XRefLinker: "+aMessage+" where template="+templateURI+" and content="+contentURI;
		SysLogger.log(SysLogger.APPLICATION, this, message);
	}
	
	private void recurse(Node n, References refs ) throws Exception
	{	switch(n.getNodeType())
		{	case Node.DOCUMENT_NODE:
			{	NodeList nl=n.getChildNodes();
				int length=nl.getLength();
				for(int i=0; i<length; i++)
				{	recurse(nl.item(i), refs);
				}
			}
			break;
			case Node.ELEMENT_NODE:
			{	String ns=n.getNamespaceURI();
				if(ns!=null && ns.equals(XRL_NS))
				{	if(n.getLocalName().equals("include"))
					{	NamedNodeMap atts=n.getAttributes();
						if(atts!=null)
						{	Node n2=atts.getNamedItem("href");
							if(n2!=null)
							{	String href=n2.getNodeValue();
								IURAspect paramAspect=null;
								if(n.hasChildNodes())
								{	Node frag=org.ten60.netkernel.xml.util.XMLUtils.getInstance().getFirstChildElement(n);
									Document d=org.ten60.netkernel.xml.util.XMLUtils.getInstance().newDocument();
									frag=d.importNode(frag,true);
									d.appendChild(frag);
									paramAspect = new DOMXDAAspect(new DOMXDA(d,false));
								}
								Link link = lookupLink(href, true,refs.contentURI,refs.linkTable);
								try
								{	//Replace xrl:include node with included fragment
									if (link!=null)
									{		IURRepresentation includeRep = GTPUtils.resolveLink(link, true, paramAspect, refs.aHelper, IXAspect.class);
											IXAspect include = (IXAspect)includeRep.getAspect(IXAspect.class);
											{	if(include!=null)
												{	Node frag=n.getOwnerDocument().importNode(include.getReadOnlyDocument().getDocumentElement(), true);
													n.getParentNode().replaceChild(frag, n);
													n=frag;
												}
												refs.cost+=4;
											}
									}
									else if(!refs.tolerant) throw new Exception("The link "+href+" cannot be found");
								}
								catch (Exception e)
								{	String content=null;
									if (refs.contentURI!=null)
									{	content=refs.contentURI.toString();
									}	
									NKFException nke = new NKFException(EXCEPTION_ID, "failed to process xrl:include href="+href, refs.templateURI.toString()+" "+content);
									nke.addCause(e);
									throw nke;
								}
							}
							else
							{	//Test for other include attributes
								if(!refs.xpath)
								{	refs.xpath=atts.getNamedItem("xpath")!=null;
								}

							}
						}
					}
					else if (!refs.eval && n.getLocalName().equals("eval"))
					{	refs.eval=false;
					}
				}
				//Look for xrl:resolve attributes
				NamedNodeMap nnm=n.getAttributes();
				if(nnm!=null)
				{	Node n2=nnm.getNamedItemNS(XRL_NS, "resolve");
					if(n2!=null)
					{	String resolveAttribute = n2.getNodeValue();
						String unresolvedLink=null;
						boolean replaced=false;
						Node text=null;
						try
						{	String linkURI="";
							if (resolveAttribute.equals("text"))
							{	NodeList nl=n.getChildNodes();
								for(int i=0; i<nl.getLength(); i++)
								{	Node c=nl.item(i);
									if(c.getNodeType()==Node.TEXT_NODE)
									{	text=c;
										linkURI= text.getNodeValue();
										break;
									}
								}
							}
							else
							{	Node n3=nnm.getNamedItem(resolveAttribute);
								if (n3!=null)
								{	linkURI=n3.getNodeValue();
								}
								else
								{	throw new NKFException("Attribute not found", "attribute "+resolveAttribute+" not found",null);
								}
							}
							if (linkURI.indexOf("[[")>=0)
							{	int p1;
								while((p1=linkURI.indexOf("[["))>=0)
								{	int p2 = linkURI.indexOf("]]");
									String innerLinkURI = linkURI.substring(p1+2,p2);
									Link link = lookupLink(innerLinkURI, false, refs.contentURI,refs.linkTable);
									if (link!=null)
									{	linkURI = linkURI.substring(0,p1)+link.getExternal()+linkURI.substring(p2+2);
										refs.cost+=2;
										replaced=true;
									}
									else
									{	unresolvedLink=innerLinkURI;
										break;
									}
								}
								if (replaced)
								{	if (resolveAttribute.equals("text") && text!=null)
									{	text.setNodeValue(linkURI);
									}
									else
									{	nnm.getNamedItem(resolveAttribute).setNodeValue(linkURI);
									}
									((Attr)n2).getOwnerElement().removeAttributeNode((Attr)n2);
								}
							}
							else
							{	Link link = lookupLink(linkURI, false, refs.contentURI, refs.linkTable);
								if (link!=null)
								{	nnm.getNamedItem(resolveAttribute).setNodeValue(link.getExternal());
									((Attr)n2).getOwnerElement().removeAttributeNode((Attr)n2);
									refs.cost+=2;
									replaced=true;
								}
								else
								{	unresolvedLink=linkURI;
								}
							}
						}
						catch (Exception e)
						{	NKFException nke=new NKFException(EXCEPTION_ID, "problem with xrl:resolve attribute "+resolveAttribute, null);
							nke.addCause(e);
							throw nke;
						}
						if (!replaced)
						{	String content=null;
							if (refs.contentURI!=null)
							{	content=refs.contentURI.toString();
							}	
							if (!refs.tolerant && unresolvedLink==null)
							{	NKFException nke = new NKFException(EXCEPTION_ID, "failed to process xrl:resolve @"+resolveAttribute, refs.templateURI.toString()+" "+content);
								throw nke;
							}
							else if(!refs.tolerant)
							{	NKFException nke = new NKFException(EXCEPTION_ID, "failed to process xrl:resolve "+unresolvedLink, refs.templateURI.toString()+" "+content);
								throw nke;
							}
						}
					}
				}
				NodeList nl=n.getChildNodes();
				int length=nl.getLength();
				for(int i=0; i<length; i++)
				{	Node nr=nl.item(i);
					if(nr.getNodeType()==Node.ELEMENT_NODE)
					{	recurse(nr, refs);
					}
				}
			}
			break;
		}
		return;	
	}
	
	
	private static class References
	{	public boolean xpath=false;
		public boolean eval=true;
		public IURRepresentation templateRep;
		public String contentURI;
		public ILinkTableAspect linkTable=null;
		public INKFConvenienceHelper aHelper=null;
		public int cost;
		public boolean tolerant;
		String templateURI;
			
		public References(){}
	}
	
	
		
}