/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: MapperExportAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/08/04 16:33:01 $
 *****************************************************************************/
package org.ten60.docxter2;

import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.representation.DOMXDAAspect;
import org.ten60.netkernel.xml.util.*;
import org.ten60.netkernel.xml.representation.*;

import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURMeta;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.util.SysLogger;

import org.w3c.dom.*;
import java.io.StringWriter;
import java.net.URI;
import java.util.*;
import java.io.IOException;
/**
 * MapperAccessor
 * @author  tab
 */
public class MapperExportAccessor extends XAccessor
{
	/** Creates a new instance of MapperAccessor */
	public MapperExportAccessor()
	{	declareArgument(OPERAND, true, false); //links doc
		declareArgument(OPERATOR, true, false); //incoming uri
		declareForgetDependencies();
	}
	
	protected IURRepresentation source(XAHelper aHelper) throws Exception
	{
		StringWriter sw=new StringWriter(1024);
		sw.write("<mapper-export>");
		IXDAReadOnly links = aHelper.getOperand().getXDA();
		URI baseURI = URI.create(links.getText("/links/@basepath", false));
		URI destBaseURI = aHelper.getURI(XAHelper.OPERATOR);
		for (IXDAReadOnlyIterator i=links.readOnlyIterator("/links/link[ext and int]"); i.hasNext(); )
		{	i.next();
			String external = i.getText("ext", true);
			String internal = i.getText("int",true);
			if (external.startsWith("/"))
			{	
				if (external.length()>1)
				{	external = external.substring(1);
				}
				else
				{	external = ".";
				}
				URI externalURI = baseURI.resolve(external);
				URI destURI = destBaseURI.resolve(external);
				if (destURI.getPath().endsWith("/"))
				{	destURI = URI.create(destURI.toString()+"index.html");
				}
				
				try
				{	String mapperString = "active:mapper";
					mapperString+="+operand@"+CompoundURIdentifier.encode(externalURI.toString());
					mapperString+="+operator@"+CompoundURIdentifier.encode(aHelper.getURI(OPERAND).toString());
					URI mapperURI = URI.create(mapperString);
					Map values = new HashMap();
					values.put(aHelper.getURI(OPERAND), aHelper.getOperand(IURAspect.class));
					IURRepresentation result = ((XAHelperExtra)aHelper).requestResourceWithValues(mapperURI, IURAspect.class,values);
					aHelper.setResource(destURI, result);
				} catch (NetKernelException e)
				{	destURI = null;
					System.out.println(e.toString());
				}
				
				sw.write("<resource>");
				sw.write("<src>");
				sw.write(XMLUtils.escape(externalURI.toString()));
				sw.write("</src>");
				if (destURI!=null)
				{	sw.write("<dst>");
					sw.write(XMLUtils.escape(destURI.toString()));
					sw.write("</dst>");
				}
				sw.write("</resource>");
				sw.flush();
			}
		}
		sw.write("</mapper-export>");
		sw.flush();
		IURMeta meta = aHelper.getDependencyMeta("text/xml", 8);
		IURAspect aspect = new StringAspect(sw.toString());
		IURRepresentation rep= new MonoRepresentationImpl(meta, aspect);
		return MirrorRepresentation.expire(rep,0);
	}
	
}
