<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/modules">
		<modules>
			<xsl:apply-templates/>
		</modules>
    </xsl:template>
	
	<xsl:template match="module">
		<xsl:variable name="uri" select="uri/text()"/>
		<xsl:variable name="version" select="version/text()"/>
		<module>
			<config>
				<xsl:value-of select="$param/modules/module[identity/uri=$uri and identity/version=$version]/info/source"/>module.xml
			</config>
			<uri><xsl:value-of select="$uri"/></uri>
			<version><xsl:value-of select="$version"/></version>
		</module>
	</xsl:template>

</xsl:stylesheet> 
