<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_products.xsl
    Created on : 10 March 2004, 16:16
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	<xsl:template match="/">
		<div>
			<h2>Products</h2>
			<a href="xrl:admin_new_product" xrl:resolve="href">new product</a>
			<xsl:apply-templates select="products/info"/>
		</div>
	</xsl:template>
		
	<xsl:template match="info">
		<xsl:choose>
			<xsl:when test="null">
				<div style="font-size: 20px;">No Products</div>
			</xsl:when>
			<xsl:otherwise>
				<div>
					<table>
						<xsl:apply-templates select="results/row"/>
					</table>
				</div>
			</xsl:otherwise>
		</xsl:choose>
    </xsl:template>
	
	<xsl:template match="row">
		<tr bgcolor="#ccccff">
			
			<td><xsl:value-of select="name"/></td>
			<td><xsl:value-of select="description"/></td>
			<td><xsl:value-of select="urn"/></td>
			<td><xsl:value-of select="state"/></td>
			<td>
				<a xrl:resolve="href">	
					<xsl:attribute name="href">
						[[xrl:admin_new_version]]?id=<xsl:value-of select="id"/>
					</xsl:attribute>
					add version</a>
				 | 
				<a xrl:resolve="href">	
					<xsl:attribute name="href">
						[[xrl:admin_delete_product]]?id=<xsl:value-of select="id"/>
					</xsl:attribute>
					delete</a>
			</td>
		</tr>
		<xsl:variable name="id" select="id"/>
		<xsl:for-each select="/products/versions/results/row[productid=$id]">
			<tr>
				<xsl:if test="position() mod 2">
					<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
				</xsl:if>
				<td><xsl:value-of select="version"/></td>
				<td><xsl:value-of select="descr"/></td>
				<td>
					<a xrl:resolve="href">	
						<xsl:attribute name="href">
							[[xrl:admin_list_version_components]]?id=<xsl:value-of select="id"/>
						</xsl:attribute>
						components</a>
				</td>
			</tr>
		</xsl:for-each>
		
	</xsl:template>

</xsl:stylesheet>
